/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.oracle;

import java.util.List;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.oracle.cdc.OracleListener;
import org.dbsyncer.connector.oracle.schema.OracleOtherValueMapper;
import org.dbsyncer.connector.oracle.validator.OracleConfigValidator;
import org.dbsyncer.sdk.config.CommandConfig;
import org.dbsyncer.sdk.config.DatabaseConfig;
import org.dbsyncer.sdk.config.ReaderConfig;
import org.dbsyncer.sdk.connector.ConfigValidator;
import org.dbsyncer.sdk.connector.database.AbstractDatabaseConnector;
import org.dbsyncer.sdk.enums.ListenerTypeEnum;
import org.dbsyncer.sdk.enums.TableTypeEnum;
import org.dbsyncer.sdk.listener.DatabaseQuartzListener;
import org.dbsyncer.sdk.listener.Listener;
import org.dbsyncer.sdk.model.PageSql;
import org.dbsyncer.sdk.model.Table;
import org.dbsyncer.sdk.util.PrimaryKeyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OracleConnector
extends AbstractDatabaseConnector {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String TYPE = "Oracle";
    private final OracleConfigValidator configValidator = new OracleConfigValidator();

    public OracleConnector() {
        this.VALUE_MAPPERS.put(1111, new OracleOtherValueMapper());
    }

    public String getConnectorType() {
        return "Oracle";
    }

    public ConfigValidator getConfigValidator() {
        return this.configValidator;
    }

    public Listener getListener(String listenerType) {
        if (ListenerTypeEnum.isTiming((String)listenerType)) {
            return new DatabaseQuartzListener();
        }
        if (ListenerTypeEnum.isLog((String)listenerType)) {
            return new OracleListener();
        }
        return null;
    }

    public String buildSqlWithQuotation() {
        return "\"";
    }

    public String getPageSql(PageSql config) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM (SELECT A.*, ROWNUM RN FROM (");
        sql.append(config.getQuerySql());
        if (PrimaryKeyUtil.isSupportedCursor((List)config.getFields())) {
            this.appendOrderByPk(config, sql);
        }
        sql.append(")A WHERE ROWNUM <= ?) WHERE RN > ?");
        return sql.toString();
    }

    public String getPageCursorSql(PageSql config) {
        if (!PrimaryKeyUtil.isSupportedCursor((List)config.getFields())) {
            this.logger.debug("\u4e0d\u652f\u6301\u6e38\u6807\u67e5\u8be2\uff0c\u4e3b\u952e\u5305\u542b\u975e\u6570\u5b57\u7c7b\u578b");
            return "";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM (SELECT A.*, ROWNUM RN FROM (");
        sql.append(config.getQuerySql());
        boolean skipFirst = false;
        if (StringUtil.isBlank((CharSequence)config.getQueryFilter())) {
            skipFirst = true;
            sql.append(" WHERE ");
        }
        String quotation = this.buildSqlWithQuotation();
        List primaryKeys = config.getPrimaryKeys();
        PrimaryKeyUtil.buildSql((StringBuilder)sql, (List)primaryKeys, (String)quotation, (String)" AND ", (String)" > ? ", (boolean)skipFirst);
        this.appendOrderByPk(config, sql);
        sql.append(")A WHERE ROWNUM <= ?) WHERE RN > ?");
        return sql.toString();
    }

    public Object[] getPageArgs(ReaderConfig config) {
        int pageSize = config.getPageSize();
        int pageIndex = config.getPageIndex();
        return new Object[]{pageIndex * pageSize, (pageIndex - 1) * pageSize};
    }

    public Object[] getPageCursorArgs(ReaderConfig config) {
        int pageSize = config.getPageSize();
        Object[] cursors = config.getCursors();
        if (null == cursors) {
            return new Object[]{pageSize, 0};
        }
        int cursorsLen = cursors.length;
        Object[] newCursors = new Object[cursorsLen + 2];
        System.arraycopy(cursors, 0, newCursors, 0, cursorsLen);
        newCursors[cursorsLen] = pageSize;
        newCursors[cursorsLen + 1] = 0;
        return newCursors;
    }

    public boolean enableCursor() {
        return true;
    }

    public String getValidationQuery() {
        return "select 1 from dual";
    }

    protected String getQueryCountSql(CommandConfig commandConfig, List<String> primaryKeys, String schema, String queryFilterSql) {
        Table table = commandConfig.getTable();
        if (StringUtil.isNotBlank((CharSequence)queryFilterSql) || TableTypeEnum.isView((String)table.getType())) {
            return super.getQueryCountSql(commandConfig, primaryKeys, schema, queryFilterSql);
        }
        DatabaseConfig cfg = (DatabaseConfig)commandConfig.getConnectorConfig();
        return String.format("SELECT NUM_ROWS FROM ALL_TABLES WHERE OWNER = '%s' AND TABLE_NAME = '%s'", cfg.getUsername().toUpperCase(), table.getName());
    }
}

