/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.oracle.dcn;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.OracleStatement;
import oracle.jdbc.dcn.DatabaseChangeEvent;
import oracle.jdbc.dcn.DatabaseChangeListener;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.dcn.RowChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.driver.OracleConnection;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.oracle.OracleException;
import org.dbsyncer.connector.oracle.dcn.RowEventListener;
import org.dbsyncer.connector.oracle.model.DCNEvent;
import org.dbsyncer.sdk.listener.event.RowChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DBChangeNotification {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String QUERY_ROW_DATA_SQL = "SELECT * FROM \"%s\" WHERE ROWID='%s'";
    private static final String QUERY_TABLE_ALL_SQL = "SELECT TABLE_NAME FROM USER_TAB_COMMENTS WHERE TABLE_TYPE='TABLE'";
    private static final String QUERY_TABLE_ID_SQL = "SELECT OBJECT_ID FROM ALL_OBJECTS WHERE OBJECT_TYPE='TABLE' AND OBJECT_NAME='%s' AND OWNER='%s'";
    private static final String QUERY_TABLE_SQL = "SELECT 1 FROM \"%s\" WHERE 1=2";
    private static final String QUERY_CALLBACK_SQL = "SELECT REGID,CALLBACK FROM USER_CHANGE_NOTIFICATION_REGS";
    private static final String CALLBACK = "net8://(ADDRESS=(PROTOCOL=tcp)(HOST=%s)(PORT=%s))?PR=0";
    private String username;
    private String password;
    private String url;
    private OracleConnection conn;
    private DatabaseChangeRegistration dcr;
    private Map<Integer, String> tables;
    private Set<String> filterTable;
    private List<RowEventListener> listeners = new ArrayList<RowEventListener>();
    private final Lock connectLock = new ReentrantLock();
    private volatile boolean connected;

    public DBChangeNotification(String username, String password, String url) {
        this.username = username;
        this.password = password;
        this.url = url;
    }

    public void addRowEventListener(RowEventListener rowEventListener) {
        this.listeners.add(rowEventListener);
    }

    public void start() throws SQLException {
        try {
            this.connectLock.lock();
            if (this.connected) {
                this.logger.error("DBChangeNotification is already started");
                return;
            }
            this.conn = this.connect();
            this.connected = true;
            OracleStatement statement = (OracleStatement)this.conn.createStatement();
            this.readTables(statement);
            Properties prop = new Properties();
            prop.setProperty("DCN_NOTIFY_ROWIDS", "true");
            prop.setProperty("DCN_IGNORE_UPDATEOP", "false");
            prop.setProperty("DCN_IGNORE_INSERTOP", "false");
            prop.setProperty("DCN_IGNORE_DELETEOP", "false");
            this.dcr = this.conn.registerDatabaseChangeNotification(prop);
            this.dcr.addListener((DatabaseChangeListener)new DCNListener());
            long regId = this.dcr.getRegId();
            String host = this.getHost(this.dcr);
            int port = this.getPort(this.dcr);
            String callback = String.format(CALLBACK, host, port);
            this.logger.info("regId:{}, callback:{}", (Object)regId, (Object)callback);
            this.clean(statement, regId, callback);
            statement.setDatabaseChangeRegistration(this.dcr);
            for (Map.Entry<Integer, String> m : this.tables.entrySet()) {
                String sql = String.format(QUERY_TABLE_SQL, m.getValue());
                try {
                    statement.executeQuery(sql);
                }
                catch (SQLException e) {
                    this.logger.debug("\u914d\u7f6e\u76d1\u542c\u8868\u5f02\u5e38:{}, {}", (Object)sql, (Object)e.getMessage());
                }
            }
            this.close((AutoCloseable)statement);
        }
        catch (SQLException ex) {
            this.close();
            throw ex;
        }
        finally {
            this.connectLock.unlock();
        }
    }

    public OracleConnection getOracleConnection() {
        return this.conn;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setFilterTable(Set<String> filterTable) {
        this.filterTable = filterTable;
    }

    public void close() {
        this.connected = false;
        try {
            if (null != this.conn) {
                this.conn.unregisterDatabaseChangeNotification(this.dcr);
            }
            this.close((AutoCloseable)this.conn);
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage());
        }
    }

    public void close(AutoCloseable rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(String tableName, String rowId, List<Object> data) {
        OracleStatement os = null;
        ResultSet rs = null;
        try {
            os = this.createStatement();
            rs = os.executeQuery(String.format(QUERY_ROW_DATA_SQL, tableName, rowId));
            if (rs.next()) {
                int size = rs.getMetaData().getColumnCount();
                do {
                    data.add(rowId);
                    for (int i = 1; i <= size; ++i) {
                        data.add(rs.getObject(i));
                    }
                } while (rs.next());
            }
            this.close(rs);
            this.close((AutoCloseable)os);
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage());
        }
        finally {
            this.close(rs);
            this.close((AutoCloseable)os);
        }
    }

    private OracleStatement createStatement() throws SQLException {
        try {
            OracleStatement statement = (OracleStatement)this.conn.createStatement();
            Assert.notNull((Object)statement, (String)"Can't create statement, trying to reconnect.");
            return statement;
        }
        catch (Exception e) {
            this.connected = false;
            this.logger.error(e.getMessage());
            this.conn = this.connect();
            this.connected = true;
            this.logger.info("\u91cd\u8fde\u6210\u529f");
            return (OracleStatement)this.conn.createStatement();
        }
    }

    private void readTables(OracleStatement statement) {
        this.tables = new LinkedHashMap<Integer, String>();
        List<String> tableList = this.queryForList(statement, QUERY_TABLE_ALL_SQL, rs -> rs.getString(1));
        Assert.notEmpty(tableList, (String)"No tables available");
        String owner = this.username.toUpperCase();
        tableList.forEach(tableName -> this.tables.put(this.queryForObject(statement, String.format(QUERY_TABLE_ID_SQL, tableName, owner), rs -> rs.getInt(1)), (String)tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> queryForList(OracleStatement statement, String sql, ResultSetMapper<T> mapper) {
        ResultSet rs = null;
        ArrayList<T> list = new ArrayList<T>();
        try {
            rs = statement.executeQuery(sql);
            while (rs.next()) {
                list.add(mapper.apply(rs));
            }
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage());
        }
        finally {
            this.close(rs);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T queryForObject(OracleStatement statement, String sql, ResultSetMapper<T> mapper) {
        ResultSet rs = null;
        T apply = null;
        try {
            rs = statement.executeQuery(sql);
            if (rs.next()) {
                apply = mapper.apply(rs);
            }
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage());
        }
        finally {
            this.close(rs);
        }
        return apply;
    }

    private Object invokeDCR(DatabaseChangeRegistration dcr, String declaredMethod) {
        try {
            Class<?> clazz = dcr.getClass().getSuperclass();
            Method method = clazz.getDeclaredMethod(declaredMethod, new Class[0]);
            method.setAccessible(true);
            return method.invoke((Object)dcr, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            this.logger.error(e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.error(e.getMessage());
        }
        catch (InvocationTargetException e) {
            this.logger.error(e.getMessage());
        }
        throw new OracleException(String.format("Can't invoke '%s'.", declaredMethod));
    }

    private String getHost(DatabaseChangeRegistration dcr) {
        if (StringUtil.isBlank((CharSequence)this.url)) {
            throw new IllegalArgumentException("url is null");
        }
        if (StringUtil.startsWith((CharSequence)this.url, (CharSequence)"jdbc:oracle:thin:@(")) {
            Object obj = this.invokeDCR(dcr, "getClientHost");
            return String.valueOf(obj);
        }
        String host = this.url.substring(this.url.indexOf("@") + 1);
        host = host.substring(0, host.indexOf(":"));
        return host;
    }

    private int getPort(DatabaseChangeRegistration dcr) {
        Object obj = this.invokeDCR(dcr, "getClientTCPPort");
        return Integer.parseInt(String.valueOf(obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean(OracleStatement statement, long excludeRegId, String excludeCallback) {
        ResultSet rs = null;
        try {
            rs = statement.executeQuery(QUERY_CALLBACK_SQL);
            while (rs.next()) {
                long regId = rs.getLong(1);
                String callback = rs.getString(2);
                if (regId == excludeRegId || !callback.equals(excludeCallback)) continue;
                this.logger.info("Clean regid:{}, callback:{}", (Object)regId, (Object)callback);
                this.conn.unregisterDatabaseChangeNotification(regId, callback);
            }
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage());
        }
        finally {
            this.close(rs);
        }
    }

    private OracleConnection connect() throws SQLException {
        OracleDriver dr = new OracleDriver();
        Properties prop = new Properties();
        prop.setProperty("user", this.username);
        prop.setProperty("password", this.password);
        return (OracleConnection)dr.connect(this.url, prop);
    }

    private void parseEvent(DCNEvent event) {
        ArrayList<Object> data = new ArrayList<Object>();
        if (event.getCode() == TableChangeDescription.TableOperation.UPDATE.getCode()) {
            this.read(event.getTableName(), event.getRowId(), data);
            this.listeners.forEach(listener -> listener.onEvents(new RowChangedEvent(event.getTableName(), "UPDATE", data)));
            return;
        }
        if (event.getCode() == TableChangeDescription.TableOperation.INSERT.getCode()) {
            this.read(event.getTableName(), event.getRowId(), data);
            this.listeners.forEach(listener -> listener.onEvents(new RowChangedEvent(event.getTableName(), "INSERT", data)));
            return;
        }
        data.add(event.getRowId());
        this.listeners.forEach(listener -> listener.onEvents(new RowChangedEvent(event.getTableName(), "DELETE", data)));
    }

    final class DCNListener
    implements DatabaseChangeListener {
        DCNListener() {
        }

        public void onDatabaseChangeNotification(DatabaseChangeEvent event) {
            if (DBChangeNotification.this.dcr.getRegId() != event.getRegId()) {
                return;
            }
            DatabaseChangeEvent.EventType eventType = event.getEventType();
            if (eventType == DatabaseChangeEvent.EventType.OBJCHANGE) {
                for (TableChangeDescription td : event.getTableChangeDescription()) {
                    RowChangeDescription[] rds;
                    for (RowChangeDescription rd : rds = td.getRowChangeDescription()) {
                        String tableName = (String)DBChangeNotification.this.tables.get(td.getObjectNumber());
                        if (!DBChangeNotification.this.filterTable.contains(tableName)) {
                            DBChangeNotification.this.logger.info("Table[{}] {}", (Object)tableName, (Object)rd.getRowOperation().name());
                            continue;
                        }
                        DBChangeNotification.this.parseEvent(new DCNEvent(tableName, rd.getRowid().stringValue(), rd.getRowOperation().getCode()));
                    }
                }
                return;
            }
            if (eventType == DatabaseChangeEvent.EventType.SHUTDOWN) {
                DBChangeNotification.this.connected = false;
                DBChangeNotification.this.logger.error("\u8fde\u63a5\u4e2d\u65ad\uff0c\u7b49\u5f85Oracle\u6570\u636e\u5e93\u91cd\u542f\u4e2d...");
                return;
            }
            if (eventType == DatabaseChangeEvent.EventType.STARTUP) {
                try {
                    DBChangeNotification.this.conn = DBChangeNotification.this.connect();
                    DBChangeNotification.this.connected = true;
                    DBChangeNotification.this.logger.info("\u91cd\u8fde\u6210\u529f");
                }
                catch (SQLException e) {
                    DBChangeNotification.this.logger.error("\u91cd\u8fde\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    private static interface ResultSetMapper<T> {
        public T apply(ResultSet var1) throws SQLException;
    }
}

