/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.oracle.logminer;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.StopWatch;
import org.dbsyncer.connector.oracle.logminer.LogFile;
import org.dbsyncer.connector.oracle.logminer.LogMinerHelper;
import org.dbsyncer.connector.oracle.logminer.RedoEvent;
import org.dbsyncer.connector.oracle.logminer.TransactionalBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMiner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Lock lock = new ReentrantLock();
    private String username;
    private String password;
    private String url;
    private String schema;
    private String driverClassName;
    private String miningStrategy = "DBMS_LOGMNR.DICT_FROM_ONLINE_CATALOG";
    private volatile boolean connected = false;
    private final StopWatch stopWatch = StopWatch.create();
    private Connection connection;
    private List<BigInteger> currentRedoLogSequences;
    private TransactionalBuffer transactionalBuffer = new TransactionalBuffer();
    private Long committedScn = 0L;
    private long startScn = 0L;
    private EventListener listener;

    public LogMiner(String username, String password, String url, String schema, String driverClassName) {
        this.username = username;
        this.password = password;
        this.url = url;
        this.schema = schema;
        this.driverClassName = driverClassName;
    }

    public void close() throws SQLException {
        this.lock.lock();
        if (!this.connected) {
            this.logger.error("LogMiner is already stop");
            this.lock.unlock();
            return;
        }
        this.connection.close();
        this.connected = false;
        this.lock.unlock();
    }

    /*
     * Exception decompiling
     */
    public void start() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long getCurrentScn(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            ResultSet rs = statement.executeQuery("select CURRENT_SCN from V$DATABASE");
            if (!rs.next()) {
                throw new IllegalStateException("Couldn't get SCN");
            }
            long l = rs.getLong(1);
            return l;
        }
    }

    private void restartLogMiner() throws SQLException {
        LogMinerHelper.endLogMiner(this.connection);
        this.initializeLogMiner();
    }

    private boolean redoLogSwitchOccurred() throws SQLException {
        List<BigInteger> newSequences = LogMinerHelper.getCurrentRedoLogSequences(this.connection);
        if (!newSequences.equals(this.currentRedoLogSequences)) {
            this.currentRedoLogSequences = newSequences;
            return true;
        }
        return false;
    }

    private BigInteger determineEndScn() throws SQLException {
        return BigInteger.valueOf(this.getCurrentScn(this.connection));
    }

    private void initializeLogMiner() throws SQLException {
        LogMinerHelper.buildDataDictionary(this.connection, this.miningStrategy);
        this.setRedoLog();
    }

    private void setRedoLog() throws SQLException {
        LogMinerHelper.removeLogFilesFromMining(this.connection);
        List<LogFile> onlineLogFiles = LogMinerHelper.getOnlineLogFilesForOffsetScn(this.connection, BigInteger.valueOf(this.startScn));
        List<LogFile> archivedLogFiles = LogMinerHelper.getArchivedLogFilesForOffsetScn(this.connection, BigInteger.valueOf(this.startScn));
        List logFilesNames = archivedLogFiles.stream().map(LogFile::getFileName).collect(Collectors.toList());
        for (LogFile onlineLogFile : onlineLogFiles) {
            boolean found = false;
            for (LogFile archivedLogFile : archivedLogFiles) {
                if (!onlineLogFile.isSameRange(archivedLogFile)) continue;
                found = true;
                break;
            }
            if (found) continue;
            logFilesNames.add(onlineLogFile.getFileName());
        }
        for (String fileName : logFilesNames) {
            LogMinerHelper.addLogFile(this.connection, fileName);
        }
    }

    private void logMinerViewProcessor(ResultSet rs) throws SQLException {
        while (rs.next()) {
            BigInteger scn = rs.getBigDecimal("SCN").toBigInteger();
            String tableName = rs.getString("TABLE_NAME");
            String segOwner = rs.getString("SEG_OWNER");
            int operationCode = rs.getInt("OPERATION_CODE");
            Timestamp changeTime = rs.getTimestamp("TIMESTAMP");
            String txId = rs.getString("XID");
            String operation = rs.getString("OPERATION");
            String username = rs.getString("USERNAME");
            this.logger.trace("Capture record, SCN:{}, TABLE_NAME:{}, SEG_OWNER:{}, OPERATION_CODE:{}, TIMESTAMP:{}, XID:{}, OPERATION:{}, USERNAME:{}", new Object[]{scn, tableName, segOwner, operationCode, changeTime, txId, operation, username});
            if (operationCode == 7) {
                if (!this.transactionalBuffer.commit(txId, scn, this.committedScn)) continue;
                this.logger.debug("txId: {} commit", (Object)txId);
                continue;
            }
            if (operationCode == 36) {
                if (!this.transactionalBuffer.rollback(txId)) continue;
                this.logger.debug("txId: {} rollback", (Object)txId);
                continue;
            }
            if (operationCode == 34) {
                this.logger.warn("Found MISSING_SCN");
                continue;
            }
            String redoSql = this.getRedoSQL(rs);
            if (operationCode == 5) {
                this.updateCommittedScn(scn.longValue());
                this.listener.onEvent(new RedoEvent(scn.longValue(), operationCode, redoSql, segOwner, tableName, changeTime, txId));
                continue;
            }
            if (operationCode != 1 && operationCode != 2 && operationCode != 3 || redoSql == null) continue;
            RedoEvent event = new RedoEvent(scn.longValue(), operationCode, redoSql, segOwner, tableName, changeTime, txId);
            TransactionalBuffer.CommitCallback commitCallback = (smallestScn, commitScn, counter) -> {
                if (smallestScn == null || scn.compareTo(smallestScn) < 0) {
                    this.startScn = scn.longValue();
                }
                if (counter == 0) {
                    this.updateCommittedScn(commitScn.longValue());
                }
                event.setScn(this.startScn < this.committedScn ? this.committedScn : this.startScn);
                this.listener.onEvent(event);
            };
            this.transactionalBuffer.registerCommitCallback(txId, scn, commitCallback);
        }
    }

    private void updateCommittedScn(long newScn) {
        this.committedScn = newScn > this.committedScn ? newScn : this.committedScn;
    }

    private String getRedoSQL(ResultSet rs) throws SQLException {
        String redoSql = rs.getString("SQL_REDO");
        if (redoSql == null) {
            return null;
        }
        StringBuilder redoBuilder = new StringBuilder(redoSql);
        int csf = rs.getInt("CSF");
        while (csf == 1) {
            rs.next();
            redoBuilder.append(rs.getString("SQL_REDO"));
            csf = rs.getInt("CSF");
        }
        return redoBuilder.toString();
    }

    public void registerEventListener(EventListener listener) {
        this.listener = listener;
    }

    public long getStartScn() {
        return this.startScn;
    }

    public void setStartScn(long startScn) {
        this.startScn = startScn;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public static interface EventListener {
        public void onEvent(RedoEvent var1);
    }
}

