/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.oracle.logminer.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import org.dbsyncer.common.column.AbstractColumnValue;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.DateFormatUtil;
import org.dbsyncer.common.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleColumnValue
extends AbstractColumnValue<Expression> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public OracleColumnValue(Expression value) {
        this.setValue(value);
    }

    public boolean isNull() {
        if (this.getValue() instanceof IsNullExpression) {
            return true;
        }
        if (this.getValue() instanceof NullValue) {
            return true;
        }
        if (this.getValue() instanceof IsNullExpression) {
            return true;
        }
        return super.isNull();
    }

    public String asString() {
        if (this.getValue() instanceof StringValue) {
            return ((StringValue)this.getValue()).getValue();
        }
        return Objects.toString(this.getValue());
    }

    public byte[] asByteArray() {
        return new byte[0];
    }

    public Short asShort() {
        return Short.valueOf(this.asString());
    }

    public Integer asInteger() {
        return Integer.valueOf(this.asString());
    }

    public Long asLong() {
        return Long.valueOf(this.asString());
    }

    public Float asFloat() {
        return Float.valueOf(this.asString());
    }

    public Double asDouble() {
        return Double.valueOf(this.asString());
    }

    public Boolean asBoolean() {
        return null;
    }

    public BigDecimal asBigDecimal() {
        return new BigDecimal(this.asString());
    }

    public Date asDate() {
        return null;
    }

    public Timestamp asTimestamp() {
        return this.handleColumnValue((type, value) -> {
            switch (type) {
                case "TO_DATE": {
                    return this.toDate(value);
                }
                case "TO_TIMESTAMP": {
                    return this.toTimestamp(value);
                }
            }
            return null;
        });
    }

    public Time asTime() {
        return null;
    }

    public BigInteger asBigInteger() {
        return new BigInteger(this.asString());
    }

    public OffsetDateTime asOffsetDateTime() {
        return this.handleColumnValue((type, value) -> {
            switch (type) {
                case "TO_TIMESTAMP_TZ": {
                    return this.toOffsetDateTime(value);
                }
            }
            return null;
        });
    }

    private <R> R handleColumnValue(ColumnValueFunction<R> function) {
        Function fun = (Function)this.getValue();
        List multipartName = fun.getMultipartName();
        ExpressionList parameters = fun.getParameters();
        if (CollectionUtils.isEmpty((Collection)multipartName) || CollectionUtils.isEmpty((Collection)parameters)) {
            return null;
        }
        String nameType = Objects.toString(multipartName.get(0));
        Object value = parameters.get(0);
        if (nameType == null || value == null) {
            return null;
        }
        if (value instanceof StringValue) {
            StringValue val = (StringValue)value;
            value = val.getValue();
        }
        try {
            return function.apply(nameType, value);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Timestamp toDate(Object value) {
        return DateFormatUtil.stringToTimestamp((String)Objects.toString(value));
    }

    private Timestamp toTimestamp(Object value) {
        return DateFormatUtil.stringToTimestamp((String)StringUtil.replace((String)Objects.toString(value), (String)".", (String)""));
    }

    private OffsetDateTime toOffsetDateTime(Object value) {
        return DateFormatUtil.timestampWithTimeZoneToOffsetDateTimeOracle((String)Objects.toString(value));
    }

    static interface ColumnValueFunction<R> {
        public R apply(String var1, Object var2);
    }
}

