/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.oracle.schema;

import com.microsoft.sqlserver.jdbc.Geometry;
import java.sql.Connection;
import java.sql.Struct;
import oracle.jdbc.OracleConnection;
import oracle.sql.STRUCT;
import org.dbsyncer.connector.oracle.OracleException;
import org.dbsyncer.connector.oracle.geometry.JGeometry;
import org.dbsyncer.sdk.connector.AbstractValueMapper;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.dbsyncer.sdk.connector.database.ds.SimpleConnection;
import org.dbsyncer.sdk.util.DatabaseUtil;

public final class OracleOtherValueMapper
extends AbstractValueMapper<Struct> {
    protected boolean skipConvert(Object val) {
        return val instanceof Struct || val instanceof String;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Struct convert(ConnectorInstance connectorInstance, Object val) throws Exception {
        Object conn;
        if (val instanceof byte[] && (conn = connectorInstance.getConnection()) instanceof SimpleConnection) {
            SimpleConnection connection = null;
            try {
                connection = (SimpleConnection)conn;
                OracleConnection oracleConnection = (OracleConnection)connection.unwrap(OracleConnection.class);
                Geometry geometry = Geometry.deserialize((byte[])((byte[])val));
                Double x = geometry.getX();
                Double y = geometry.getY();
                JGeometry jGeometry = new JGeometry(x, y, 0);
                STRUCT sTRUCT = JGeometry.store(jGeometry, (Connection)oracleConnection);
                return sTRUCT;
            }
            finally {
                DatabaseUtil.close((AutoCloseable)connection);
            }
        }
        throw new OracleException(String.format("%s can not find type [%s], val [%s]", ((Object)((Object)this)).getClass().getSimpleName(), val.getClass(), val));
    }
}

