/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.storage.impl;

import java.time.Instant;
import org.dbsyncer.common.CommonException;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="dbsyncer.web.worker")
public class SnowflakeIdWorker {
    private long id = 1L;
    private long dataCenterId = 1L;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private final long twepoch = 1420041600000L;
    private final long workerIdBits = 5L;
    private final long dataCenterIdBits = 5L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long dataCenterIdShift = 17L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 4095L;

    public SnowflakeId revert(Long id) {
        long workerId = id >> 12 & 0x1FL;
        long dataCenterId = id >> 17 & 0x1FL;
        long timestamp = new Long(id >> 22) + 1420041600000L;
        return new SnowflakeId(workerId, dataCenterId, timestamp);
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new CommonException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1420041600000L << 22 | this.dataCenterId << 17 | this.id << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return Instant.now().toEpochMilli();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getDataCenterId() {
        return this.dataCenterId;
    }

    public void setDataCenterId(long dataCenterId) {
        this.dataCenterId = dataCenterId;
    }

    private class SnowflakeId {
        private long workerId;
        private long dataCenterId;
        private long timestamp;

        public SnowflakeId(long workerId, long dataCenterId, long timestamp) {
            this.workerId = workerId;
            this.dataCenterId = dataCenterId;
            this.timestamp = timestamp;
        }

        public long getWorkerId() {
            return this.workerId;
        }

        public long getDataCenterId() {
            return this.dataCenterId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

