/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.storage.util;

import java.util.Map;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.springframework.util.Assert;

public abstract class DocumentUtil {
    private DocumentUtil() {
    }

    public static Document convertConfig2Doc(Map params) {
        Assert.notNull((Object)params, (String)"Params can not be null.");
        Document doc = new Document();
        String id = (String)params.get("id");
        String type = (String)params.get("type");
        String name = (String)params.get("name");
        String json = (String)params.get("json");
        Long createTime = (Long)params.get("createTime");
        Long updateTime = (Long)params.get("updateTime");
        doc.add((IndexableField)new StringField("id", id, Field.Store.YES));
        doc.add((IndexableField)new StringField("type", type, Field.Store.YES));
        doc.add((IndexableField)new TextField("name", name, Field.Store.YES));
        doc.add((IndexableField)new StoredField("json", json));
        doc.add((IndexableField)new LongPoint("createTime", new long[]{createTime}));
        doc.add((IndexableField)new NumericDocValuesField("createTime", createTime));
        doc.add((IndexableField)new LongPoint("updateTime", new long[]{updateTime}));
        doc.add((IndexableField)new NumericDocValuesField("updateTime", updateTime));
        return doc;
    }

    public static Document convertLog2Doc(Map params) {
        Assert.notNull((Object)params, (String)"Params can not be null.");
        Document doc = new Document();
        String id = (String)params.get("id");
        String type = (String)params.get("type");
        String json = (String)params.get("json");
        Long createTime = (Long)params.get("createTime");
        doc.add((IndexableField)new StringField("id", id, Field.Store.YES));
        doc.add((IndexableField)new StringField("type", type, Field.Store.YES));
        doc.add((IndexableField)new TextField("json", json, Field.Store.YES));
        doc.add((IndexableField)new LongPoint("createTime", new long[]{createTime}));
        doc.add((IndexableField)new StoredField("createTime", createTime.longValue()));
        doc.add((IndexableField)new NumericDocValuesField("createTime", createTime));
        return doc;
    }

    public static Document convertData2Doc(Map params) {
        Assert.notNull((Object)params, (String)"Params can not be null.");
        Document doc = new Document();
        String id = (String)params.get("id");
        Integer success = (Integer)params.get("success");
        String tableGroupId = (String)params.get("tableGroupId");
        String targetTableName = (String)params.get("targetTableName");
        String event = (String)params.get("event");
        String error = (String)params.get("error");
        Long createTime = (Long)params.get("createTime");
        doc.add((IndexableField)new StringField("id", id, Field.Store.YES));
        doc.add((IndexableField)new IntPoint("success", new int[]{success}));
        doc.add((IndexableField)new StoredField("success", success.intValue()));
        doc.add((IndexableField)new StringField("tableGroupId", tableGroupId, Field.Store.YES));
        doc.add((IndexableField)new StringField("targetTableName", targetTableName, Field.Store.YES));
        doc.add((IndexableField)new StringField("event", event, Field.Store.YES));
        doc.add((IndexableField)new TextField("error", error, Field.Store.YES));
        byte[] bytes = (byte[])params.get("data");
        doc.add((IndexableField)new BinaryDocValuesField("data", new BytesRef(bytes)));
        doc.add((IndexableField)new StoredField("data", bytes));
        doc.add((IndexableField)new LongPoint("createTime", new long[]{createTime}));
        doc.add((IndexableField)new StoredField("createTime", createTime.longValue()));
        doc.add((IndexableField)new NumericDocValuesField("createTime", createTime));
        return doc;
    }
}

