/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector;

import java.util.LinkedHashMap;
import java.util.Map;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.sdk.SdkException;
import org.dbsyncer.sdk.config.WriterBatchConfig;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.dbsyncer.sdk.connector.ValueMapper;
import org.dbsyncer.sdk.connector.schema.BigintValueMapper;
import org.dbsyncer.sdk.connector.schema.BinaryValueMapper;
import org.dbsyncer.sdk.connector.schema.BitValueMapper;
import org.dbsyncer.sdk.connector.schema.BlobValueMapper;
import org.dbsyncer.sdk.connector.schema.CharValueMapper;
import org.dbsyncer.sdk.connector.schema.ClobValueMapper;
import org.dbsyncer.sdk.connector.schema.DateValueMapper;
import org.dbsyncer.sdk.connector.schema.DecimalValueMapper;
import org.dbsyncer.sdk.connector.schema.DoubleValueMapper;
import org.dbsyncer.sdk.connector.schema.FloatValueMapper;
import org.dbsyncer.sdk.connector.schema.IntegerValueMapper;
import org.dbsyncer.sdk.connector.schema.LongVarBinaryValueMapper;
import org.dbsyncer.sdk.connector.schema.LongVarcharValueMapper;
import org.dbsyncer.sdk.connector.schema.NCharValueMapper;
import org.dbsyncer.sdk.connector.schema.NClobValueMapper;
import org.dbsyncer.sdk.connector.schema.NVarcharValueMapper;
import org.dbsyncer.sdk.connector.schema.NumberValueMapper;
import org.dbsyncer.sdk.connector.schema.OtherValueMapper;
import org.dbsyncer.sdk.connector.schema.RealValueMapper;
import org.dbsyncer.sdk.connector.schema.RowIdValueMapper;
import org.dbsyncer.sdk.connector.schema.SmallintValueMapper;
import org.dbsyncer.sdk.connector.schema.TimeValueMapper;
import org.dbsyncer.sdk.connector.schema.TimestampValueMapper;
import org.dbsyncer.sdk.connector.schema.TinyintValueMapper;
import org.dbsyncer.sdk.connector.schema.VarBinaryValueMapper;
import org.dbsyncer.sdk.connector.schema.VarcharValueMapper;
import org.dbsyncer.sdk.model.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnector {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Map<Integer, ValueMapper> VALUE_MAPPERS = new LinkedHashMap<Integer, ValueMapper>();

    public AbstractConnector() {
        this.VALUE_MAPPERS.putIfAbsent(12, new VarcharValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(4, new IntegerValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(-5, new BigintValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(93, new TimestampValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(91, new DateValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(1, new CharValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(-15, new NCharValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(-9, new NVarcharValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(-1, new LongVarcharValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(2, new NumberValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(-2, new BinaryValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(5, new SmallintValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(-6, new TinyintValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(92, new TimeValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(3, new DecimalValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(8, new DoubleValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(6, new FloatValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(-7, new BitValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(2004, new BlobValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(2005, new ClobValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(2011, new NClobValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(-8, new RowIdValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(7, new RealValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(-3, new VarBinaryValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(-4, new LongVarBinaryValueMapper());
        this.VALUE_MAPPERS.putIfAbsent(1111, new OtherValueMapper());
    }

    public void convertProcessBeforeWriter(ConnectorInstance connectorInstance, WriterBatchConfig config) {
        if (CollectionUtils.isEmpty(config.getFields()) || CollectionUtils.isEmpty(config.getData())) {
            return;
        }
        for (Map row : config.getData()) {
            for (Field f : config.getFields()) {
                ValueMapper valueMapper;
                if (null == f || null == (valueMapper = this.VALUE_MAPPERS.get(f.getType()))) continue;
                try {
                    row.put(f.getName(), valueMapper.convertValue(connectorInstance, row.get(f.getName())));
                }
                catch (Exception e) {
                    this.logger.error("convert value error: ({}, {})", (Object)f.getName(), row.get(f.getName()));
                    throw new SdkException(e);
                }
            }
        }
    }

    protected boolean isUpdate(String event) {
        return StringUtil.equals((CharSequence)"UPDATE", (CharSequence)event);
    }

    protected boolean isInsert(String event) {
        return StringUtil.equals((CharSequence)"INSERT", (CharSequence)event);
    }

    protected boolean isDelete(String event) {
        return StringUtil.equals((CharSequence)"DELETE", (CharSequence)event);
    }
}

