/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.JsonUtil;
import org.dbsyncer.sdk.config.DatabaseConfig;
import org.dbsyncer.sdk.connector.ConfigValidator;
import org.dbsyncer.sdk.model.SqlTable;
import org.springframework.util.Assert;

public abstract class AbstractDataBaseConfigValidator
implements ConfigValidator<DatabaseConfig> {
    @Override
    public void modify(DatabaseConfig connectorConfig, Map<String, String> params) {
        String username = params.get("username");
        String password = params.get("password");
        String url = params.get("url");
        String driverClassName = params.get("driverClassName");
        Assert.hasText((String)username, (String)"Username is empty.");
        Assert.hasText((String)password, (String)"Password is empty.");
        Assert.hasText((String)url, (String)"Url is empty.");
        connectorConfig.setUsername(username);
        connectorConfig.setPassword(password);
        connectorConfig.setUrl(url);
        connectorConfig.setDriverClassName(driverClassName);
    }

    protected void modifyDql(DatabaseConfig connectorConfig, Map<String, String> params) {
        String sqlTableParams = params.get("sqlTableParams");
        Assert.hasText((String)sqlTableParams, (String)"sqlTableParams is empty.");
        List sqlTables = JsonUtil.jsonToArray((String)sqlTableParams, SqlTable.class);
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)sqlTables) ? 1 : 0) != 0, (String)"sqlTables is empty.");
        sqlTables.forEach(sqlTable -> {
            Assert.hasText((String)sqlTable.getSqlName(), (String)"SqlName is empty.");
            Assert.hasText((String)sqlTable.getSql(), (String)"Sql is empty.");
            Assert.hasText((String)sqlTable.getTable(), (String)"Table is empty.");
        });
        connectorConfig.setSqlTables(sqlTables);
    }

    protected void modifySchema(DatabaseConfig connectorConfig, Map<String, String> params) {
        String schema = params.get("schema");
        Assert.hasText((String)schema, (String)"Schema is empty.");
        connectorConfig.setSchema(schema);
    }
}

