/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector.database.sqlbuilder;

import java.util.List;
import org.dbsyncer.sdk.config.SqlBuilderConfig;
import org.dbsyncer.sdk.connector.database.AbstractSqlBuilder;
import org.dbsyncer.sdk.connector.database.Database;
import org.dbsyncer.sdk.model.Field;

public class SqlBuilderInsert
extends AbstractSqlBuilder {
    @Override
    public String buildSql(SqlBuilderConfig config) {
        Database database = config.getDatabase();
        String quotation = database.buildSqlWithQuotation();
        List<Field> fields = config.getFields();
        StringBuilder fs = new StringBuilder();
        StringBuilder vs = new StringBuilder();
        int size = fields.size();
        int end = size - 1;
        for (int i = 0; i < size; ++i) {
            fs.append(quotation);
            fs.append(database.buildFieldName(fields.get(i)));
            fs.append(quotation);
            vs.append("?");
            if (i >= end) continue;
            fs.append(", ");
            vs.append(", ");
        }
        StringBuilder sql = new StringBuilder(database.generateUniqueCode());
        sql.append("INSERT INTO ");
        sql.append(config.getSchema());
        sql.append(quotation);
        sql.append(database.buildTableName(config.getTableName()));
        sql.append(quotation);
        sql.append("(").append((CharSequence)fs).append(") VALUES (").append((CharSequence)vs).append(")");
        return sql.toString();
    }
}

