/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector.database.sqlbuilder;

import java.util.List;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.sdk.config.SqlBuilderConfig;
import org.dbsyncer.sdk.connector.database.AbstractSqlBuilder;
import org.dbsyncer.sdk.connector.database.Database;
import org.dbsyncer.sdk.model.Field;
import org.dbsyncer.sdk.model.PageSql;

public class SqlBuilderQuery
extends AbstractSqlBuilder {
    @Override
    public String buildSql(SqlBuilderConfig config) {
        List<String> primaryKeys = config.getPrimaryKeys();
        String queryFilter = config.getQueryFilter();
        List<Field> fields = config.getFields();
        PageSql pageSql = new PageSql(this.buildQuerySql(config), queryFilter, primaryKeys, fields);
        return config.getDatabase().getPageSql(pageSql);
    }

    @Override
    public String buildQuerySql(SqlBuilderConfig config) {
        Database database = config.getDatabase();
        String quotation = database.buildSqlWithQuotation();
        List<Field> fields = config.getFields();
        String queryFilter = config.getQueryFilter();
        StringBuilder sql = new StringBuilder("SELECT ");
        int size = fields.size();
        int end = size - 1;
        Field field = null;
        for (int i = 0; i < size; ++i) {
            field = fields.get(i);
            if (field.isUnmodifiabled()) {
                sql.append(field.getName());
            } else {
                sql.append(quotation);
                sql.append(database.buildFieldName(field));
                sql.append(quotation);
            }
            if (StringUtil.isNotBlank((CharSequence)field.getLabelName())) {
                sql.append(" as ").append(quotation).append(field.getLabelName()).append(quotation);
            }
            if (i >= end) continue;
            sql.append(", ");
        }
        sql.append(" FROM ").append(config.getSchema()).append(quotation);
        sql.append(database.buildTableName(config.getTableName()));
        sql.append(quotation);
        if (StringUtil.isNotBlank((CharSequence)queryFilter)) {
            sql.append(queryFilter);
        }
        return sql.toString();
    }
}

