/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector.database.sqlbuilder;

import java.util.List;
import org.dbsyncer.sdk.config.SqlBuilderConfig;
import org.dbsyncer.sdk.connector.database.Database;
import org.dbsyncer.sdk.connector.database.sqlbuilder.SqlBuilderQuery;
import org.dbsyncer.sdk.util.PrimaryKeyUtil;

public class SqlBuilderQueryExist
extends SqlBuilderQuery {
    @Override
    public String buildSql(SqlBuilderConfig config) {
        Database database = config.getDatabase();
        String quotation = database.buildSqlWithQuotation();
        String tableName = config.getTableName();
        String schema = config.getSchema();
        List<String> primaryKeys = database.buildPrimaryKeys(config.getPrimaryKeys());
        StringBuilder sql = new StringBuilder("SELECT COUNT(1) FROM ");
        sql.append(schema).append(quotation);
        sql.append(database.buildTableName(tableName));
        sql.append(quotation);
        sql.append(" WHERE ");
        PrimaryKeyUtil.buildSql(sql, primaryKeys, quotation, " AND ", " = ? ", true);
        return sql.toString();
    }
}

