/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector.database.sqlbuilder;

import java.util.List;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.sdk.config.SqlBuilderConfig;
import org.dbsyncer.sdk.connector.database.AbstractSqlBuilder;
import org.dbsyncer.sdk.connector.database.Database;
import org.dbsyncer.sdk.model.Field;
import org.dbsyncer.sdk.util.PrimaryKeyUtil;

public class SqlBuilderUpdate
extends AbstractSqlBuilder {
    @Override
    public String buildSql(SqlBuilderConfig config) {
        Database database = config.getDatabase();
        String quotation = database.buildSqlWithQuotation();
        List<Field> fields = config.getFields();
        StringBuilder sql = new StringBuilder(database.generateUniqueCode());
        sql.append("UPDATE ").append(config.getSchema());
        sql.append(quotation);
        sql.append(database.buildTableName(config.getTableName()));
        sql.append(quotation).append(" SET ");
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            if (fields.get(i).isPk()) continue;
            sql.append(quotation);
            sql.append(database.buildFieldName(fields.get(i)));
            sql.append(quotation).append("=?");
            if (i >= size - 1) continue;
            sql.append(",");
        }
        int last = sql.length() - 1;
        if (StringUtil.equals((CharSequence)",", (CharSequence)sql.substring(last))) {
            sql.deleteCharAt(last);
        }
        sql.append(" WHERE ");
        List<String> primaryKeys = database.buildPrimaryKeys(config.getPrimaryKeys());
        PrimaryKeyUtil.buildSql(sql, primaryKeys, quotation, " AND ", " = ? ", true);
        return sql.toString();
    }
}

