/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector.schema;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.dbsyncer.sdk.SdkException;
import org.dbsyncer.sdk.connector.AbstractValueMapper;
import org.dbsyncer.sdk.connector.ConnectorInstance;

public class DecimalValueMapper
extends AbstractValueMapper<BigDecimal> {
    @Override
    protected BigDecimal convert(ConnectorInstance connectorInstance, Object val) {
        if (val instanceof Integer) {
            Integer integer = (Integer)val;
            return new BigDecimal(integer);
        }
        if (val instanceof Long) {
            Long l = (Long)val;
            return new BigDecimal(l);
        }
        if (val instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)val;
            return new BigDecimal(bigInteger);
        }
        if (val instanceof Short) {
            Short s = (Short)val;
            return new BigDecimal(s.shortValue());
        }
        if (val instanceof Float) {
            Float f = (Float)val;
            return new BigDecimal(Float.toString(f.floatValue()));
        }
        if (val instanceof Boolean) {
            Boolean b = (Boolean)val;
            return new BigDecimal(b != false ? 1 : 0);
        }
        if (val instanceof String) {
            String s = (String)val;
            return new BigDecimal(s);
        }
        throw new SdkException(String.format("%s can not find type [%s], val [%s]", this.getClass().getSimpleName(), val.getClass(), val));
    }
}

