/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector.schema;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.dbsyncer.sdk.SdkException;
import org.dbsyncer.sdk.connector.AbstractValueMapper;
import org.dbsyncer.sdk.connector.ConnectorInstance;

public class VarBinaryValueMapper
extends AbstractValueMapper<byte[]> {
    @Override
    protected Object getDefaultVal(Object val) {
        return null != val ? val : (Object)new byte[0];
    }

    @Override
    protected byte[] convert(ConnectorInstance connectorInstance, Object val) {
        if (val instanceof BitSet) {
            BitSet bitSet = (BitSet)val;
            return this.toByteArray(bitSet);
        }
        if (val instanceof Boolean) {
            Boolean b = (Boolean)val;
            ByteBuffer buffer = ByteBuffer.allocate(2);
            buffer.putShort((short)(b != false ? 1 : 0));
            return buffer.array();
        }
        throw new SdkException(String.format("%s can not find type [%s], val [%s]", this.getClass().getSimpleName(), val.getClass(), val));
    }

    public byte[] toByteArray(BitSet bits) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            int n = bytes.length - i / 8 - 1;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        return bytes;
    }
}

