/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.enums;

import org.dbsyncer.common.util.NumberUtil;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.sdk.SdkException;
import org.dbsyncer.sdk.filter.CompareFilter;

public enum FilterEnum {
    EQUAL("=", (value, filterValue) -> StringUtil.equals((CharSequence)value, (CharSequence)filterValue)),
    NOT_EQUAL("!=", (value, filterValue) -> !StringUtil.equals((CharSequence)value, (CharSequence)filterValue)),
    GT(">", (value, filterValue) -> NumberUtil.toLong((String)value) > NumberUtil.toLong((String)filterValue)),
    LT("<", (value, filterValue) -> NumberUtil.toLong((String)value) < NumberUtil.toLong((String)filterValue)),
    GT_AND_EQUAL(">=", (value, filterValue) -> NumberUtil.toLong((String)value) >= NumberUtil.toLong((String)filterValue)),
    LT_AND_EQUAL("<=", (value, filterValue) -> NumberUtil.toLong((String)value) <= NumberUtil.toLong((String)filterValue)),
    LIKE("like", (value, filterValue) -> {
        boolean startsWith = StringUtil.startsWith((CharSequence)filterValue, (CharSequence)"%") || StringUtil.startsWith((CharSequence)filterValue, (CharSequence)"*");
        boolean endsWith = StringUtil.endsWith((CharSequence)filterValue, (CharSequence)"%") || StringUtil.endsWith((CharSequence)filterValue, (CharSequence)"*");
        String compareValue = StringUtil.replace((String)filterValue, (String)"%", (String)"");
        compareValue = StringUtil.replace((String)compareValue, (String)"*", (String)"");
        if (startsWith && endsWith) {
            return StringUtil.contains((CharSequence)value, (CharSequence)compareValue);
        }
        if (endsWith) {
            return StringUtil.startsWith((CharSequence)value, (CharSequence)compareValue);
        }
        if (startsWith) {
            return StringUtil.endsWith((CharSequence)value, (CharSequence)compareValue);
        }
        return false;
    });

    private String name;
    private CompareFilter compareFilter;

    private FilterEnum(String name, CompareFilter compareFilter) {
        this.name = name;
        this.compareFilter = compareFilter;
    }

    public static FilterEnum getFilterEnum(String name) throws SdkException {
        for (FilterEnum e : FilterEnum.values()) {
            if (!StringUtil.equals((CharSequence)name, (CharSequence)e.getName())) continue;
            return e;
        }
        throw new SdkException(String.format("FilterEnum name \"%s\" does not exist.", name));
    }

    public static CompareFilter getCompareFilter(String filterName) throws SdkException {
        for (FilterEnum e : FilterEnum.values()) {
            if (!StringUtil.equals((CharSequence)filterName, (CharSequence)e.getName())) continue;
            return e.getCompareFilter();
        }
        throw new SdkException(String.format("FilterEnum name \"%s\" does not exist.", filterName));
    }

    public String getName() {
        return this.name;
    }

    public CompareFilter getCompareFilter() {
        return this.compareFilter;
    }
}

