/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.filter;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dbsyncer.sdk.enums.FilterEnum;
import org.dbsyncer.sdk.enums.SortEnum;
import org.dbsyncer.sdk.enums.StorageEnum;
import org.dbsyncer.sdk.filter.BooleanFilter;
import org.dbsyncer.sdk.filter.FieldResolver;
import org.dbsyncer.sdk.filter.impl.IntFilter;
import org.dbsyncer.sdk.filter.impl.StringFilter;

public class Query {
    private StorageEnum type;
    private String metaId;
    private BooleanFilter booleanFilter = new BooleanFilter();
    private boolean queryTotal;
    private int pageNum = 1;
    private int pageSize = 20;
    private SortEnum sort = SortEnum.DESC;
    private Map<String, FieldResolver> fieldResolverMap = new ConcurrentHashMap<String, FieldResolver>();

    public Query() {
    }

    public Query(int pageNum, int pageSize) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
    }

    public void addFilter(String name, String value) {
        this.booleanFilter.add(new StringFilter(name, FilterEnum.EQUAL, value, false));
    }

    public void addFilter(String name, String value, boolean enableHighLightSearch) {
        this.booleanFilter.add(new StringFilter(name, FilterEnum.LIKE, value, enableHighLightSearch));
    }

    public void addFilter(String name, int value) {
        this.booleanFilter.add(new IntFilter(name, value));
    }

    public StorageEnum getType() {
        return this.type;
    }

    public void setType(StorageEnum type) {
        this.type = type;
    }

    public String getMetaId() {
        return this.metaId;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    public BooleanFilter getBooleanFilter() {
        return this.booleanFilter;
    }

    public void setBooleanFilter(BooleanFilter booleanFilter) {
        this.booleanFilter = booleanFilter;
    }

    public boolean isQueryTotal() {
        return this.queryTotal;
    }

    public void setQueryTotal(boolean queryTotal) {
        this.queryTotal = queryTotal;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public SortEnum getSort() {
        return this.sort;
    }

    public void setSort(SortEnum sort) {
        this.sort = sort;
    }

    public Map<String, FieldResolver> getFieldResolverMap() {
        return this.fieldResolverMap;
    }

    public void setFieldResolverMap(Map<String, FieldResolver> fieldResolverMap) {
        this.fieldResolverMap = fieldResolverMap;
    }
}

