/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.listener;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.dbsyncer.common.scheduled.ScheduledTaskService;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.sdk.config.ListenerConfig;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.dbsyncer.sdk.listener.ChangedEvent;
import org.dbsyncer.sdk.listener.Listener;
import org.dbsyncer.sdk.listener.Watcher;
import org.dbsyncer.sdk.model.ChangedOffset;
import org.dbsyncer.sdk.model.ConnectorConfig;
import org.dbsyncer.sdk.model.Table;
import org.dbsyncer.sdk.spi.ConnectorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractListener<C extends ConnectorInstance>
implements Listener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int FLUSH_DELAYED_SECONDS = 20;
    protected ConnectorInstance connectorInstance;
    protected ConnectorService connectorService;
    protected ScheduledTaskService scheduledTaskService;
    protected ConnectorConfig connectorConfig;
    protected ListenerConfig listenerConfig;
    protected Set<String> filterTable;
    protected List<Table> sourceTable;
    protected Map<String, String> snapshot;
    protected String metaId;
    private Watcher watcher;

    @Override
    public void register(Watcher watcher) {
        this.watcher = watcher;
    }

    @Override
    public void changeEvent(ChangedEvent event) {
        if (null != event) {
            switch (event.getEvent()) {
                case "UPDATE": {
                    this.processEvent(!this.listenerConfig.isBanUpdate(), event);
                    break;
                }
                case "INSERT": {
                    this.processEvent(!this.listenerConfig.isBanInsert(), event);
                    break;
                }
                case "DELETE": {
                    this.processEvent(!this.listenerConfig.isBanDelete(), event);
                    break;
                }
                case "ALTER": {
                    this.processEvent(!this.listenerConfig.isBanDDL(), event);
                    break;
                }
            }
        }
    }

    @Override
    public void refreshEvent(ChangedOffset offset) {
    }

    @Override
    public void flushEvent() {
        if (this.watcher.getMetaUpdateTime() > Timestamp.valueOf(LocalDateTime.now().minusSeconds(20L)).getTime() && !CollectionUtils.isEmpty(this.snapshot)) {
            this.logger.info("snapshot\uff1a{}", this.snapshot);
            this.watcher.flushEvent(this.snapshot);
        }
    }

    @Override
    public void forceFlushEvent() {
        if (!CollectionUtils.isEmpty(this.snapshot)) {
            this.logger.info("snapshot\uff1a{}", this.snapshot);
            this.watcher.flushEvent(this.snapshot);
        }
    }

    @Override
    public void errorEvent(Exception e) {
        this.watcher.errorEvent(e);
    }

    protected void sleepInMills(long timeout) {
        try {
            TimeUnit.MILLISECONDS.sleep(timeout);
        }
        catch (InterruptedException e) {
            this.logger.info(e.getMessage());
        }
    }

    private void processEvent(boolean permitEvent, ChangedEvent event) {
        if (permitEvent) {
            this.watcher.changeEvent(event);
        }
    }

    public void setConnectorInstance(ConnectorInstance connectorInstance) {
        this.connectorInstance = connectorInstance;
    }

    public void setConnectorService(ConnectorService connectorService) {
        this.connectorService = connectorService;
    }

    public C getConnectorInstance() {
        return (C)this.connectorInstance;
    }

    public void setScheduledTaskService(ScheduledTaskService scheduledTaskService) {
        this.scheduledTaskService = scheduledTaskService;
    }

    public void setConnectorConfig(ConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    public void setListenerConfig(ListenerConfig listenerConfig) {
        this.listenerConfig = listenerConfig;
    }

    public void setFilterTable(Set<String> filterTable) {
        this.filterTable = filterTable;
    }

    public AbstractListener setSourceTable(List<Table> sourceTable) {
        this.sourceTable = sourceTable;
        return this;
    }

    public void setSnapshot(Map<String, String> snapshot) {
        this.snapshot = snapshot;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }
}

