/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.spi;

import java.util.List;
import java.util.Map;
import org.dbsyncer.common.model.Result;
import org.dbsyncer.sdk.SdkException;
import org.dbsyncer.sdk.config.CommandConfig;
import org.dbsyncer.sdk.config.DDLConfig;
import org.dbsyncer.sdk.config.ReaderConfig;
import org.dbsyncer.sdk.config.WriterBatchConfig;
import org.dbsyncer.sdk.connector.ConfigValidator;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.dbsyncer.sdk.listener.Listener;
import org.dbsyncer.sdk.model.ConnectorConfig;
import org.dbsyncer.sdk.model.MetaInfo;
import org.dbsyncer.sdk.model.Table;
import org.dbsyncer.sdk.storage.StorageService;

public interface ConnectorService<I extends ConnectorInstance, C extends ConnectorConfig> {
    public String getConnectorType();

    public boolean isSupportedTiming();

    public boolean isSupportedLog();

    public Class<C> getConfigClass();

    public ConnectorInstance connect(C var1);

    public ConfigValidator getConfigValidator();

    public void disconnect(I var1);

    public boolean isAlive(I var1);

    public String getConnectorInstanceCacheKey(C var1);

    public List<Table> getTable(I var1);

    public MetaInfo getMetaInfo(I var1, String var2);

    public long getCount(I var1, Map<String, String> var2);

    public Result reader(I var1, ReaderConfig var2);

    public Result writer(I var1, WriterBatchConfig var2);

    default public Result writerDDL(I connectorInstance, DDLConfig ddlConfig) {
        throw new SdkException("Unsupported method.");
    }

    public Map<String, String> getSourceCommand(CommandConfig var1);

    public Map<String, String> getTargetCommand(CommandConfig var1);

    public Listener getListener(String var1);

    default public StorageService getStorageService() {
        return null;
    }
}

