/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.sdk.SdkException;

public abstract class DatabaseUtil {
    public static Connection getConnection(String driverClassName, String url, String username, String password) throws SQLException {
        if (StringUtil.isNotBlank((CharSequence)driverClassName)) {
            try {
                Class.forName(driverClassName);
            }
            catch (ClassNotFoundException e) {
                throw new SdkException(e.getCause());
            }
        }
        return DriverManager.getConnection(url, username, password);
    }

    public static void close(AutoCloseable rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getDatabaseName(String url) {
        Matcher matcher = Pattern.compile("(//)(?!(\\?)).+?(\\?)").matcher(url);
        if (matcher.find()) {
            url = matcher.group(0);
        }
        int s = url.lastIndexOf("/");
        int e = url.lastIndexOf("?");
        if (s > 0 && e > 0) {
            return StringUtil.substring((String)url, (int)(s + 1), (int)e);
        }
        throw new SdkException("database is invalid");
    }
}

