/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.NumberUtil;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.sdk.SdkException;
import org.dbsyncer.sdk.config.WriterBatchConfig;
import org.dbsyncer.sdk.model.Field;
import org.dbsyncer.sdk.model.Table;

public abstract class PrimaryKeyUtil {
    public static List<String> findTablePrimaryKeys(Table table) {
        if (null == table) {
            throw new SdkException("The table is null.");
        }
        List<String> primaryKeys = PrimaryKeyUtil.findPrimaryKeys(table.getColumn());
        if (!CollectionUtils.isEmpty(table.getColumn()) && CollectionUtils.isEmpty(primaryKeys)) {
            throw new SdkException(String.format("\u76ee\u6807\u8868 %s \u7f3a\u5c11\u4e3b\u952e.", table.getName()));
        }
        return primaryKeys;
    }

    public static List<String> findPrimaryKeys(List<Field> fields) {
        return PrimaryKeyUtil.findPrimaryKeyFields(fields).stream().map(f -> f.getName()).collect(Collectors.toList());
    }

    public static List<Field> findConfigPrimaryKeyFields(WriterBatchConfig config) {
        if (null == config) {
            throw new SdkException("The config is null.");
        }
        List<Field> list = PrimaryKeyUtil.findPrimaryKeyFields(config.getFields());
        if (CollectionUtils.isEmpty(list)) {
            throw new SdkException("\u4e3b\u952e\u4e3a\u7a7a");
        }
        return list;
    }

    public static List<Field> findPrimaryKeyFields(List<Field> fields) {
        ArrayList list = new ArrayList();
        if (!CollectionUtils.isEmpty(fields)) {
            HashSet mark = new HashSet();
            fields.forEach(f -> {
                if (f.isPk() && !mark.contains(f.getName())) {
                    list.add(f);
                    mark.add(f.getName());
                }
            });
        }
        return Collections.unmodifiableList(list);
    }

    public static void buildSql(StringBuilder sql, List<String> primaryKeys, String quotation, String join, String value, boolean skipFirst) {
        AtomicBoolean added = new AtomicBoolean();
        primaryKeys.forEach(pk -> {
            if ((!skipFirst || added.get()) && StringUtil.isNotBlank((CharSequence)join)) {
                sql.append(join);
            }
            sql.append(quotation).append((String)pk).append(quotation);
            if (StringUtil.isNotBlank((CharSequence)value)) {
                sql.append(value);
            }
            added.set(true);
        });
    }

    public static boolean isSupportedCursor(List<Field> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return false;
        }
        HashMap typeAliases = new HashMap();
        fields.forEach(field -> {
            if (field.isPk()) {
                typeAliases.put(field.getName(), field.getType());
            }
        });
        for (Integer pkType : typeAliases.values()) {
            if (PrimaryKeyUtil.isSupportedCursorType(pkType)) continue;
            return false;
        }
        return !CollectionUtils.isEmpty(typeAliases);
    }

    private static boolean isSupportedCursorType(Integer type) {
        return type == 2 || type == -5 || type == 4 || type == -6 || type == 5;
    }

    public static Object[] getLastCursors(List<Map> data, List<String> primaryKeys) {
        if (CollectionUtils.isEmpty(data)) {
            return null;
        }
        Map last = data.get(data.size() - 1);
        Object[] cursors = new Object[primaryKeys.size()];
        Iterator<String> iterator = primaryKeys.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String pk = iterator.next();
            cursors[i] = last.get(pk);
            ++i;
        }
        return cursors;
    }

    public static Object[] getLastCursors(String str) {
        Object[] cursors = null;
        if (StringUtil.isNotBlank((CharSequence)str)) {
            String[] split = StringUtil.split((String)str, (String)",");
            int length = split.length;
            cursors = new Object[length];
            for (int i = 0; i < length; ++i) {
                String val = split[i];
                cursors[i] = NumberUtil.isCreatable((String)val) ? Long.valueOf(NumberUtil.toLong((String)val)) : val;
            }
        }
        return cursors;
    }
}

