/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.manager.impl;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.dbsyncer.common.util.NumberUtil;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.manager.AbstractPuller;
import org.dbsyncer.parser.LogService;
import org.dbsyncer.parser.LogType;
import org.dbsyncer.parser.ParserComponent;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.enums.ParserEnum;
import org.dbsyncer.parser.event.FullRefreshEvent;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.Mapping;
import org.dbsyncer.parser.model.Meta;
import org.dbsyncer.parser.model.TableGroup;
import org.dbsyncer.parser.model.Task;
import org.dbsyncer.sdk.util.PrimaryKeyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public final class FullPuller
extends AbstractPuller
implements ApplicationListener<FullRefreshEvent> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ParserComponent parserComponent;
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private LogService logService;
    private Map<String, Task> map = new ConcurrentHashMap<String, Task>();

    @Override
    public void start(Mapping mapping) {
        Thread worker = new Thread(() -> {
            String metaId = mapping.getMetaId();
            ExecutorService executor = null;
            try {
                List list = this.profileComponent.getSortedTableGroupAll(mapping.getId());
                Assert.notEmpty((Collection)list, (String)"\u6620\u5c04\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a");
                this.logger.info("\u5f00\u59cb\u5168\u91cf\u540c\u6b65\uff1a{}, {}", (Object)metaId, (Object)mapping.getName());
                this.map.putIfAbsent(metaId, new Task(metaId));
                executor = Executors.newFixedThreadPool(mapping.getThreadNum());
                Task task = this.map.get(metaId);
                this.doTask(task, mapping, list, executor);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                this.logService.log((LogType)LogType.SystemLog.ERROR, e.getMessage());
            }
            finally {
                try {
                    if (executor != null) {
                        executor.shutdown();
                    }
                }
                catch (Exception e) {
                    this.logService.log((LogType)LogType.SystemLog.ERROR, e.getMessage());
                }
                this.map.remove(metaId);
                this.publishClosedEvent(metaId);
                this.logger.info("\u7ed3\u675f\u5168\u91cf\u540c\u6b65\uff1a{}, {}", (Object)metaId, (Object)mapping.getName());
            }
        });
        worker.setName("full-worker-" + mapping.getId());
        worker.setDaemon(false);
        worker.start();
    }

    @Override
    public void close(String metaId) {
        Task task = this.map.get(metaId);
        if (null != task) {
            task.stop();
        }
    }

    public void onApplicationEvent(FullRefreshEvent event) {
        this.flush(event.getTask());
    }

    private void doTask(Task task, Mapping mapping, List<TableGroup> list, Executor executor) {
        long now = Instant.now().toEpochMilli();
        task.setBeginTime(now);
        task.setEndTime(now);
        Meta meta = this.profileComponent.getMeta(task.getId());
        Map snapshot = meta.getSnapshot();
        task.setPageIndex(NumberUtil.toInt((String)((String)snapshot.get(ParserEnum.PAGE_INDEX.getCode())), (int)ParserEnum.PAGE_INDEX.getDefaultValue()));
        String cursorValue = (String)snapshot.get(ParserEnum.CURSOR.getCode());
        task.setCursors(PrimaryKeyUtil.getLastCursors((String)cursorValue));
        task.setTableGroupIndex(NumberUtil.toInt((String)((String)snapshot.get(ParserEnum.TABLE_GROUP_INDEX.getCode())), (int)ParserEnum.TABLE_GROUP_INDEX.getDefaultValue()));
        this.flush(task);
        int i = task.getTableGroupIndex();
        while (i < list.size()) {
            this.parserComponent.execute(task, mapping, list.get(i), executor);
            if (!task.isRunning()) break;
            task.setPageIndex(ParserEnum.PAGE_INDEX.getDefaultValue());
            task.setCursors(null);
            task.setTableGroupIndex(++i);
            this.flush(task);
        }
        task.setEndTime(Instant.now().toEpochMilli());
        task.setTableGroupIndex(ParserEnum.TABLE_GROUP_INDEX.getDefaultValue());
        this.flush(task);
    }

    private void flush(Task task) {
        Meta meta = this.profileComponent.getMeta(task.getId());
        Assert.notNull((Object)meta, (String)"\u68c0\u67e5meta\u4e3a\u7a7a.");
        long finished = meta.getSuccess().get() + meta.getFail().get();
        if (meta.getTotal().get() < finished) {
            meta.getTotal().set(finished);
        }
        meta.setBeginTime(task.getBeginTime());
        meta.setEndTime(task.getEndTime());
        meta.setUpdateTime(Long.valueOf(Instant.now().toEpochMilli()));
        Map snapshot = meta.getSnapshot();
        snapshot.put(ParserEnum.PAGE_INDEX.getCode(), String.valueOf(task.getPageIndex()));
        snapshot.put(ParserEnum.CURSOR.getCode(), StringUtil.join((Object[])task.getCursors(), (String)","));
        snapshot.put(ParserEnum.TABLE_GROUP_INDEX.getCode(), String.valueOf(task.getTableGroupIndex()));
        this.profileComponent.editConfigModel((ConfigModel)meta);
    }
}

