/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.manager.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.dbsyncer.common.model.Paging;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.JsonUtil;
import org.dbsyncer.connector.base.ConnectorFactory;
import org.dbsyncer.manager.ManagerFactory;
import org.dbsyncer.parser.LogService;
import org.dbsyncer.parser.LogType;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.command.Command;
import org.dbsyncer.parser.command.impl.PreloadCommand;
import org.dbsyncer.parser.enums.CommandEnum;
import org.dbsyncer.parser.enums.GroupStrategyEnum;
import org.dbsyncer.parser.enums.MetaEnum;
import org.dbsyncer.parser.impl.OperationTemplate;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.Mapping;
import org.dbsyncer.parser.model.OperationConfig;
import org.dbsyncer.plugin.PluginFactory;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.dbsyncer.sdk.enums.StorageEnum;
import org.dbsyncer.sdk.filter.Query;
import org.dbsyncer.sdk.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public final class PreloadTemplate
implements ApplicationListener<ContextRefreshedEvent> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private OperationTemplate operationTemplate;
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private ManagerFactory managerFactory;
    @Resource
    private ConnectorFactory connectorFactory;
    @Resource
    private PluginFactory pluginFactory;
    @Resource
    private StorageService storageService;
    @Resource
    private LogService logService;
    @Resource
    private Executor generalExecutor;
    private boolean preloadCompleted;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        Arrays.stream(CommandEnum.values()).filter(commandEnum -> commandEnum.isPreload()).forEach(commandEnum -> this.execute((CommandEnum)commandEnum));
        this.pluginFactory.loadPlugins();
        this.loadConnectorInstance();
        this.launch();
        this.preloadCompleted = true;
    }

    public boolean isPreloadCompleted() {
        return this.preloadCompleted;
    }

    public void reload(String json) {
        Map map = (Map)JsonUtil.jsonToObj((String)json, Map.class);
        if (CollectionUtils.isEmpty((Map)map)) {
            return;
        }
        Stream.of(CommandEnum.PRELOAD_SYSTEM, CommandEnum.PRELOAD_USER, CommandEnum.PRELOAD_CONNECTOR, CommandEnum.PRELOAD_MAPPING, CommandEnum.PRELOAD_META, CommandEnum.PRELOAD_PROJECT_GROUP).forEach(commandEnum -> this.reload(map, (CommandEnum)commandEnum));
        this.loadConnectorInstance();
        this.launch();
    }

    private void launch() {
        List metas = this.profileComponent.getMetaAll();
        if (!CollectionUtils.isEmpty((Collection)metas)) {
            metas.forEach(m -> {
                if (MetaEnum.RUNNING.getCode() == m.getState()) {
                    Mapping mapping = this.profileComponent.getMapping(m.getMappingId());
                    this.managerFactory.start(mapping);
                } else if (MetaEnum.STOPPING.getCode() == m.getState()) {
                    this.managerFactory.changeMetaState(m.getId(), MetaEnum.READY);
                }
            });
        }
    }

    private void execute(CommandEnum commandEnum) {
        Query query = new Query();
        query.setType(StorageEnum.CONFIG);
        String modelType = commandEnum.getModelType();
        query.addFilter("type", modelType);
        int pageNum = 1;
        int pageSize = 20;
        long total = 0L;
        while (true) {
            query.setPageNum(pageNum);
            query.setPageSize(pageSize);
            Paging paging = this.storageService.query(query);
            List data = (List)paging.getData();
            if (CollectionUtils.isEmpty((Collection)data)) break;
            data.forEach(map -> {
                String json = (String)map.get("json");
                ConfigModel model = (ConfigModel)commandEnum.getCommandExecutor().execute((Command)new PreloadCommand(this.profileComponent, json));
                if (null != model) {
                    this.operationTemplate.cache(model, commandEnum.getGroupStrategyEnum());
                }
            });
            total += paging.getTotal();
            ++pageNum;
        }
        this.logger.info("{}:{}", (Object)modelType, (Object)total);
    }

    private void reload(Map<String, Map> map, CommandEnum commandEnum) {
        this.reload(map, commandEnum, commandEnum.getModelType());
    }

    private void reload(Map<String, Map> map, CommandEnum commandEnum, String groupId) {
        Map config = map.get(groupId);
        if (null == config) {
            return;
        }
        OperationTemplate.Group group = (OperationTemplate.Group)JsonUtil.jsonToObj((String)config.toString(), OperationTemplate.Group.class);
        if (null == group) {
            return;
        }
        List index = group.getIndex();
        if (CollectionUtils.isEmpty((Collection)index)) {
            return;
        }
        for (String e : index) {
            Map m = map.get(e);
            ConfigModel model = (ConfigModel)commandEnum.getCommandExecutor().execute((Command)new PreloadCommand(this.profileComponent, m.toString()));
            this.operationTemplate.execute(new OperationConfig(model, CommandEnum.OPR_ADD, commandEnum.getGroupStrategyEnum()));
            if (CommandEnum.PRELOAD_MAPPING != commandEnum) continue;
            this.reload(map, CommandEnum.PRELOAD_TABLE_GROUP, this.operationTemplate.getGroupId(model, GroupStrategyEnum.PRELOAD_TABLE_GROUP));
        }
    }

    private void loadConnectorInstance() {
        List list = this.profileComponent.getConnectorAll();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(connector -> this.generalExecutor.execute(() -> {
                try {
                    this.connectorFactory.disconnect(connector.getConfig());
                    ConnectorInstance connectorInstance = this.connectorFactory.connect(connector.getConfig());
                    this.logger.info("Completed connection {} {}", (Object)connector.getConfig().getConnectorType(), (Object)connectorInstance.getServiceUrl());
                }
                catch (Exception e) {
                    this.logger.error("\u8fde\u63a5\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
                    this.logService.log((LogType)LogType.ConnectorLog.FAILED, e.getMessage());
                }
            }));
        }
    }
}

