/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.kafka.enums;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.kafka.common.KafkaException;
import org.dbsyncer.common.util.StringUtil;

public enum KafkaFieldTypeEnum {
    STRING("String", String.class, 12),
    INTEGER("Integer", Integer.class, 4),
    LONG("Long", Long.class, -5),
    SHORT("Short", Short.class, 5),
    FLOAT("Float", Float.class, 6),
    DOUBLE("Double", Double.class, 8),
    BOOLEAN("Boolean", Boolean.class, -7),
    DATE("Date", Date.class, 91),
    TIME("Time", Time.class, 92),
    TIMESTAMP("Timestamp", Timestamp.class, 93);

    private String code;
    private Class clazz;
    private int type;

    private KafkaFieldTypeEnum(String code, Class clazz, int type) {
        this.code = code;
        this.clazz = clazz;
        this.type = type;
    }

    public static Class getType(String code) throws KafkaException {
        for (KafkaFieldTypeEnum e : KafkaFieldTypeEnum.values()) {
            if (!StringUtil.equals((CharSequence)e.getCode(), (CharSequence)code)) continue;
            return e.getClazz();
        }
        throw new KafkaException(String.format("Unsupported code: %s", code));
    }

    public String getCode() {
        return this.code;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public int getType() {
        return this.type;
    }
}

