/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.kafka.validator;

import java.util.Map;
import org.dbsyncer.common.util.NumberUtil;
import org.dbsyncer.connector.kafka.config.KafkaConfig;
import org.dbsyncer.sdk.connector.ConfigValidator;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class KafkaConfigValidator
implements ConfigValidator<KafkaConfig> {
    public void modify(KafkaConfig connectorConfig, Map<String, String> params) {
        String bootstrapServers = params.get("bootstrapServers");
        String topic = params.get("topic");
        String fields = params.get("fields");
        Assert.hasText((String)bootstrapServers, (String)"bootstrapServers is empty.");
        Assert.hasText((String)topic, (String)"topic is empty.");
        Assert.hasText((String)fields, (String)"fields is empty.");
        String groupId = params.get("groupId");
        String serializer = params.get("serializer");
        Assert.hasText((String)groupId, (String)"groupId is empty.");
        Assert.hasText((String)serializer, (String)"serializer is empty.");
        int sessionTimeoutMs = NumberUtil.toInt((String)params.get("sessionTimeoutMs"));
        int maxPartitionFetchBytes = NumberUtil.toInt((String)params.get("maxPartitionFetchBytes"));
        String deserializer = params.get("deserializer");
        String acks = params.get("acks");
        Assert.hasText((String)deserializer, (String)"deserializer is empty.");
        Assert.hasText((String)acks, (String)"acks is empty.");
        int bufferMemory = NumberUtil.toInt((String)params.get("bufferMemory"));
        int batchSize = NumberUtil.toInt((String)params.get("batchSize"));
        int lingerMs = NumberUtil.toInt((String)params.get("lingerMs"));
        int retries = NumberUtil.toInt((String)params.get("retries"));
        int maxRequestSize = NumberUtil.toInt((String)params.get("maxRequestSize"));
        connectorConfig.setBootstrapServers(bootstrapServers);
        connectorConfig.setTopic(topic);
        connectorConfig.setFields(fields);
        connectorConfig.setGroupId(groupId);
        connectorConfig.setSerializer(serializer);
        connectorConfig.setSessionTimeoutMs(sessionTimeoutMs);
        connectorConfig.setMaxPartitionFetchBytes(maxPartitionFetchBytes);
        connectorConfig.setDeserializer(deserializer);
        connectorConfig.setBufferMemory(bufferMemory);
        connectorConfig.setBatchSize(batchSize);
        connectorConfig.setLingerMs(lingerMs);
        connectorConfig.setAcks(acks);
        connectorConfig.setRetries(retries);
        connectorConfig.setMaxRequestSize(maxRequestSize);
    }
}

