/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.repositories.get;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetRepositoriesAction
extends TransportMasterNodeReadAction<GetRepositoriesRequest, GetRepositoriesResponse> {
    @Inject
    public TransportGetRepositoriesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/repository/get", transportService, clusterService, threadPool, actionFilters, GetRepositoriesRequest::new, indexNameExpressionResolver, GetRepositoriesResponse::new, "same");
    }

    @Override
    protected ClusterBlockException checkBlock(GetRepositoriesRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void masterOperation(GetRepositoriesRequest request, ClusterState state, ActionListener<GetRepositoriesResponse> listener) {
        RepositoriesMetadata repositories = state.metadata().custom("repositories", RepositoriesMetadata.EMPTY);
        if (request.repositories().length == 0 || request.repositories().length == 1 && ("_all".equals(request.repositories()[0]) || "*".equals(request.repositories()[0]))) {
            listener.onResponse(new GetRepositoriesResponse(repositories));
        } else {
            LinkedHashSet<String> repositoriesToGet = new LinkedHashSet<String>();
            for (String repositoryOrPattern : request.repositories()) {
                if (!Regex.isSimpleMatchPattern(repositoryOrPattern)) {
                    repositoriesToGet.add(repositoryOrPattern);
                    continue;
                }
                for (RepositoryMetadata repository : repositories.repositories()) {
                    if (!Regex.simpleMatch(repositoryOrPattern, repository.name())) continue;
                    repositoriesToGet.add(repository.name());
                }
            }
            ArrayList<RepositoryMetadata> repositoryListBuilder = new ArrayList<RepositoryMetadata>();
            for (String repository : repositoriesToGet) {
                RepositoryMetadata repositoryMetadata = repositories.repository(repository);
                if (repositoryMetadata == null) {
                    listener.onFailure(new RepositoryMissingException(repository));
                    return;
                }
                repositoryListBuilder.add(repositoryMetadata);
            }
            listener.onResponse(new GetRepositoriesResponse(new RepositoriesMetadata(repositoryListBuilder)));
        }
    }
}

