/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import com.carrotsearch.hppc.ObjectIntHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class AwarenessAllocationDecider
extends AllocationDecider {
    public static final String NAME = "awareness";
    public static final Setting<List<String>> CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING = Setting.listSetting("cluster.routing.allocation.awareness.attributes", Collections.emptyList(), Function.identity(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Settings> CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING = Setting.groupSetting("cluster.routing.allocation.awareness.force.", Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile List<String> awarenessAttributes;
    private volatile Map<String, List<String>> forcedAwarenessAttributes;
    private static final Decision YES_NOT_ENABLED = Decision.single(Decision.Type.YES, "awareness", "allocation awareness is not enabled, set cluster setting [" + CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.getKey() + "] to enable it", new Object[0]);
    private static final Decision YES_ALL_MET = Decision.single(Decision.Type.YES, "awareness", "node meets all awareness attribute requirements", new Object[0]);

    public AwarenessAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.awarenessAttributes = CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING, this::setAwarenessAttributes);
        this.setForcedAwarenessAttributes(CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING.get(settings));
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING, this::setForcedAwarenessAttributes);
    }

    private void setForcedAwarenessAttributes(Settings forceSettings) {
        HashMap<String, List<String>> forcedAwarenessAttributes = new HashMap<String, List<String>>();
        Map<String, Settings> forceGroups = forceSettings.getAsGroups();
        for (Map.Entry<String, Settings> entry : forceGroups.entrySet()) {
            List<String> aValues = entry.getValue().getAsList("values");
            if (aValues.size() <= 0) continue;
            forcedAwarenessAttributes.put(entry.getKey(), aValues);
        }
        this.forcedAwarenessAttributes = forcedAwarenessAttributes;
    }

    private void setAwarenessAttributes(List<String> awarenessAttributes) {
        this.awarenessAttributes = awarenessAttributes;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.underCapacity(shardRouting, node, allocation, true);
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.underCapacity(shardRouting, node, allocation, false);
    }

    private Decision underCapacity(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation, boolean moveToNode) {
        if (this.awarenessAttributes.isEmpty()) {
            return YES_NOT_ENABLED;
        }
        boolean debug = allocation.debugDecision();
        IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shardRouting.index());
        int shardCount = indexMetadata.getNumberOfReplicas() + 1;
        for (String awarenessAttribute : this.awarenessAttributes) {
            int maximumNodeCount;
            int currentNodeCount;
            if (!node.node().getAttributes().containsKey(awarenessAttribute)) {
                return debug ? AwarenessAllocationDecider.debugNoMissingAttribute(awarenessAttribute, this.awarenessAttributes) : Decision.NO;
            }
            ObjectIntHashMap<String> nodesPerAttribute = allocation.routingNodes().nodesPerAttributesCounts(awarenessAttribute);
            ObjectIntHashMap shardPerAttribute = new ObjectIntHashMap();
            for (ShardRouting assignedShard : allocation.routingNodes().assignedShards(shardRouting.shardId())) {
                if (!assignedShard.started() && !assignedShard.initializing()) continue;
                RoutingNode routingNode = allocation.routingNodes().node(assignedShard.currentNodeId());
                shardPerAttribute.addTo((Object)routingNode.node().getAttributes().get(awarenessAttribute), 1);
            }
            if (moveToNode) {
                if (shardRouting.assignedToNode()) {
                    String nodeId;
                    String string = nodeId = shardRouting.relocating() ? shardRouting.relocatingNodeId() : shardRouting.currentNodeId();
                    if (!node.nodeId().equals(nodeId)) {
                        shardPerAttribute.putOrAdd((Object)allocation.routingNodes().node(nodeId).node().getAttributes().get(awarenessAttribute), 0, -1);
                        shardPerAttribute.addTo((Object)node.node().getAttributes().get(awarenessAttribute), 1);
                    }
                } else {
                    shardPerAttribute.addTo((Object)node.node().getAttributes().get(awarenessAttribute), 1);
                }
            }
            int numberOfAttributes = nodesPerAttribute.size();
            List<String> fullValues = this.forcedAwarenessAttributes.get(awarenessAttribute);
            if (fullValues != null) {
                for (String fullValue : fullValues) {
                    if (shardPerAttribute.containsKey((Object)fullValue)) continue;
                    ++numberOfAttributes;
                }
            }
            if ((currentNodeCount = shardPerAttribute.get((Object)node.node().getAttributes().get(awarenessAttribute))) <= (maximumNodeCount = (shardCount + numberOfAttributes - 1) / numberOfAttributes)) continue;
            return debug ? AwarenessAllocationDecider.debugNoTooManyCopies(shardCount, awarenessAttribute, numberOfAttributes, currentNodeCount, maximumNodeCount) : Decision.NO;
        }
        return YES_ALL_MET;
    }

    private static Decision debugNoTooManyCopies(int shardCount, String awarenessAttribute, int numberOfAttributes, int currentNodeCount, int maximumNodeCount) {
        return Decision.single(Decision.Type.NO, NAME, "there are too many copies of the shard allocated to nodes with attribute [%s], there are [%d] total configured shard copies for this shard id and [%d] total attribute values, expected the allocated shard count per attribute [%d] to be less than or equal to the upper bound of the required number of shards per attribute [%d]", awarenessAttribute, shardCount, numberOfAttributes, currentNodeCount, maximumNodeCount);
    }

    private static Decision debugNoMissingAttribute(String awarenessAttribute, List<String> awarenessAttributes) {
        return Decision.single(Decision.Type.NO, NAME, "node does not contain the awareness attribute [%s]; required attributes cluster setting [%s=%s]", awarenessAttribute, CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.getKey(), Strings.collectionToCommaDelimitedString(awarenessAttributes));
    }
}

