/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.MapXContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.ArraySourceValueFetcher;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;

public abstract class AbstractGeometryFieldMapper<Parsed, Processed>
extends FieldMapper {
    private final Explicit<Boolean> ignoreMalformed;
    private final Explicit<Boolean> ignoreZValue;
    private final Indexer<Parsed, Processed> indexer;
    private final Parser<Parsed> parser;

    public static FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformedParam(Function<FieldMapper, Explicit<Boolean>> initializer, boolean ignoreMalformedByDefault) {
        return FieldMapper.Parameter.explicitBoolParam("ignore_malformed", true, initializer, ignoreMalformedByDefault);
    }

    public static FieldMapper.Parameter<Explicit<Boolean>> ignoreZValueParam(Function<FieldMapper, Explicit<Boolean>> initializer) {
        return FieldMapper.Parameter.explicitBoolParam("ignore_z_value", true, initializer, true);
    }

    protected AbstractGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, Map<String, NamedAnalyzer> indexAnalyzers, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Indexer<Parsed, Processed> indexer, Parser<Parsed> parser) {
        super(simpleName, mappedFieldType, indexAnalyzers, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
        this.ignoreZValue = ignoreZValue;
        this.indexer = indexer;
        this.parser = parser;
    }

    protected AbstractGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Indexer<Parsed, Processed> indexer, Parser<Parsed> parser) {
        this(simpleName, mappedFieldType, Collections.emptyMap(), ignoreMalformed, ignoreZValue, multiFields, copyTo, indexer, parser);
    }

    @Override
    public AbstractGeometryFieldType fieldType() {
        return (AbstractGeometryFieldType)this.mappedFieldType;
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    protected abstract void addStoredFields(ParseContext var1, Processed var2);

    protected abstract void addDocValuesFields(String var1, Processed var2, List<IndexableField> var3, ParseContext var4);

    protected abstract void addMultiFields(ParseContext var1, Processed var2) throws IOException;

    @Override
    public void parse(ParseContext context) throws IOException {
        AbstractGeometryFieldType mappedFieldType = this.fieldType();
        try {
            Processed shape = context.parseExternalValue(this.indexer.processedClass());
            if (shape == null) {
                Parsed geometry = this.parser.parse(context.parser());
                if (geometry == null) {
                    return;
                }
                shape = this.indexer.prepareForIndexing(geometry);
            }
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
            if (mappedFieldType.isSearchable() || mappedFieldType.hasDocValues()) {
                fields.addAll(this.indexer.indexShape(context, shape));
            }
            ArrayList<IndexableField> indexedFields = new ArrayList<IndexableField>();
            if (mappedFieldType.isSearchable()) {
                indexedFields.addAll(fields);
            }
            if (this.fieldType().isStored()) {
                this.addStoredFields(context, shape);
            }
            if (this.fieldType().hasDocValues()) {
                this.addDocValuesFields(mappedFieldType.name(), shape, fields, context);
            } else if (this.fieldType().isStored() || this.fieldType().isSearchable()) {
                this.createFieldNamesField(context);
            }
            for (IndexableField field : indexedFields) {
                context.doc().add(field);
            }
            this.addMultiFields(context, shape);
        }
        catch (Exception e) {
            if (!this.ignoreMalformed.value().booleanValue()) {
                throw new MapperParsingException("failed to parse field [{}] of type [{}]", (Throwable)e, this.fieldType().name(), this.fieldType().typeName());
            }
            context.addIgnoredField(mappedFieldType.name());
        }
    }

    public boolean ignoreMalformed() {
        return this.ignoreMalformed.value();
    }

    public boolean ignoreZValue() {
        return this.ignoreZValue.value();
    }

    public static interface Indexer<Parsed, Processed> {
        public Processed prepareForIndexing(Parsed var1);

        public Class<Processed> processedClass();

        public List<IndexableField> indexShape(ParseContext var1, Processed var2);
    }

    public static abstract class Parser<Parsed> {
        public abstract Parsed parse(XContentParser var1) throws IOException, ParseException;

        public abstract Object format(Parsed var1, String var2);

        public Object parseAndFormatObject(Object value, String format) {
            Parsed geometry;
            try (MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, Collections.singletonMap("dummy_field", value), XContentType.JSON);){
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                geometry = this.parse((XContentParser)parser);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            return this.format(geometry, format);
        }
    }

    public static abstract class AbstractGeometryFieldType
    extends MappedFieldType {
        protected final Parser<?> geometryParser;
        protected final boolean parsesArrayValue;

        protected AbstractGeometryFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, boolean parsesArrayValue, Parser<?> geometryParser, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.NONE, meta);
            this.parsesArrayValue = parsesArrayValue;
            this.geometryParser = geometryParser;
        }

        @Override
        public final Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("Geometry fields do not support exact searching, use dedicated geometry queries instead: [" + this.name() + "]");
        }

        @Override
        public final ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            String geoFormat = format != null ? format : "geojson";
            final Function<Object, Object> valueParser = value -> this.geometryParser.parseAndFormatObject(value, geoFormat);
            if (this.parsesArrayValue) {
                return new ArraySourceValueFetcher(this.name(), context){

                    @Override
                    protected Object parseSourceValue(Object value) {
                        return valueParser.apply(value);
                    }
                };
            }
            return new SourceValueFetcher(this.name(), context){

                @Override
                protected Object parseSourceValue(Object value) {
                    return valueParser.apply(value);
                }
            };
        }
    }
}

