/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.TermQueryPrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.PackedQuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.QuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.ShapesAvailability;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.geo.parsers.ShapeParser;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoShapeFieldMapper;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.LegacyGeoShapeIndexer;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.LegacyGeoShapeQueryProcessor;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;

@Deprecated
public class LegacyGeoShapeFieldMapper
extends AbstractShapeGeometryFieldMapper<ShapeBuilder<?, ?, ?>, Shape> {
    public static final String CONTENT_TYPE = "geo_shape";
    public static final Set<String> DEPRECATED_PARAMETERS = new HashSet<String>(Arrays.asList("strategy", "tree", "tree_levels", "precision", "distance_error_pct", "points_only"));
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(LegacyGeoShapeFieldMapper.class);
    private final Version indexCreatedVersion;
    private final Builder builder;

    public static boolean containsDeprecatedParameter(Set<String> paramKeys) {
        return DEPRECATED_PARAMETERS.stream().anyMatch(paramKeys::contains);
    }

    private static Builder builder(FieldMapper in) {
        return ((LegacyGeoShapeFieldMapper)in).builder;
    }

    public LegacyGeoShapeFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, LegacyGeoShapeIndexer indexer, LegacyGeoShapeParser parser, Builder builder) {
        super(simpleName, mappedFieldType, Collections.singletonMap(mappedFieldType.name(), Lucene.KEYWORD_ANALYZER), builder.ignoreMalformed.get(), builder.coerce.get(), builder.ignoreZValue.get(), builder.orientation.get(), multiFields, copyTo, indexer, parser);
        this.indexCreatedVersion = builder.indexCreatedVersion;
        this.builder = builder;
    }

    @Override
    public GeoShapeFieldType fieldType() {
        return (GeoShapeFieldType)super.fieldType();
    }

    String strategy() {
        return this.fieldType().strategy().getStrategyName();
    }

    @Override
    protected void addStoredFields(ParseContext context, Shape geometry) {
    }

    @Override
    protected void addDocValuesFields(String name, Shape geometry, List<IndexableField> fields, ParseContext context) {
    }

    @Override
    protected void addMultiFields(ParseContext context, Shape geometry) {
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.indexCreatedVersion, this.builder.ignoreMalformed.getDefaultValue().value(), this.builder.coerce.getDefaultValue().value()).init(this);
    }

    @Override
    protected void checkIncomingMergeType(FieldMapper mergeWith) {
        if (mergeWith instanceof GeoShapeFieldMapper) {
            throw new IllegalArgumentException("mapper [" + this.name() + "] of type [geo_shape] cannot change strategy from [" + this.strategy() + "] to [BKD]");
        }
        super.checkIncomingMergeType(mergeWith);
    }

    public static class Builder
    extends FieldMapper.Builder {
        FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> LegacyGeoShapeFieldMapper.builder((FieldMapper)m).indexed.get(), true);
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> LegacyGeoShapeFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<Explicit<Boolean>> coerce;
        FieldMapper.Parameter<Explicit<ShapeBuilder.Orientation>> orientation = AbstractShapeGeometryFieldMapper.orientationParam(m -> LegacyGeoShapeFieldMapper.builder((FieldMapper)m).orientation.get());
        FieldMapper.Parameter<SpatialStrategy> strategy = new FieldMapper.Parameter<SpatialStrategy>("strategy", false, () -> SpatialStrategy.RECURSIVE, (n, c, o) -> SpatialStrategy.fromString(o.toString(), DEPRECATION_LOGGER), m -> LegacyGeoShapeFieldMapper.builder((FieldMapper)m).strategy.get()).deprecated();
        FieldMapper.Parameter<String> tree = FieldMapper.Parameter.stringParam("tree", false, m -> LegacyGeoShapeFieldMapper.builder((FieldMapper)m).tree.get(), "quadtree").deprecated();
        FieldMapper.Parameter<Integer> treeLevels = new FieldMapper.Parameter<Integer>("tree_levels", false, () -> null, (n, c, o) -> o == null ? null : Integer.valueOf(XContentMapValues.nodeIntegerValue(o)), m -> LegacyGeoShapeFieldMapper.builder((FieldMapper)m).treeLevels.get()).deprecated();
        FieldMapper.Parameter<DistanceUnit.Distance> precision = new FieldMapper.Parameter<DistanceUnit.Distance>("precision", false, () -> null, (n, c, o) -> o == null ? null : DistanceUnit.Distance.parseDistance(o.toString()), m -> LegacyGeoShapeFieldMapper.builder((FieldMapper)m).precision.get()).deprecated();
        FieldMapper.Parameter<Double> distanceErrorPct = new FieldMapper.Parameter<Double>("distance_error_pct", true, () -> null, (n, c, o) -> o == null ? null : Double.valueOf(XContentMapValues.nodeDoubleValue(o)), m -> LegacyGeoShapeFieldMapper.builder((FieldMapper)m).distanceErrorPct.get()).deprecated().acceptsNull();
        FieldMapper.Parameter<Boolean> pointsOnly = new FieldMapper.Parameter<Boolean>("points_only", false, () -> null, (n, c, o) -> XContentMapValues.nodeBooleanValue(o), m -> LegacyGeoShapeFieldMapper.builder((FieldMapper)m).pointsOnly.get()).deprecated().acceptsNull();
        FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final Version indexCreatedVersion;

        public Builder(String name, Version version, boolean ignoreMalformedByDefault, boolean coerceByDefault) {
            super(name);
            if (!ShapesAvailability.JTS_AVAILABLE || !ShapesAvailability.SPATIAL4J_AVAILABLE) {
                throw new ElasticsearchParseException("Non-BKD field parameters are not supported for [{}] field type", LegacyGeoShapeFieldMapper.CONTENT_TYPE);
            }
            this.indexCreatedVersion = version;
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> LegacyGeoShapeFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), ignoreMalformedByDefault);
            this.coerce = AbstractShapeGeometryFieldMapper.coerceParam(m -> LegacyGeoShapeFieldMapper.builder((FieldMapper)m).coerce.get(), coerceByDefault);
            this.pointsOnly.setValidator(v -> {
                if (v == null) {
                    return;
                }
                if (!v.booleanValue() && SpatialStrategy.TERM == this.strategy.get()) {
                    throw new IllegalArgumentException("points_only cannot be set to false for term strategy");
                }
            });
            if (version.onOrAfter(Version.V_7_0_0)) {
                this.strategy.alwaysSerialize();
            }
            this.strategy.setSerializer((b, f, v) -> b.field(f, v.getStrategyName()), SpatialStrategy::getStrategyName);
            this.treeLevels.setSerializerCheck((id, ic, v) -> ic || id && this.precision.get() == null);
            this.treeLevels.setSerializer((b, f, v) -> {
                if (v != null && v != 0) {
                    b.field(f, v);
                } else {
                    b.field(f, Defaults.defaultTreeLevel(this.tree.get()));
                }
            }, Objects::toString);
            this.precision.setSerializerCheck((id, ic, v) -> ic || id && this.treeLevels.get() == null);
            this.precision.setSerializer((b, f, v) -> {
                if (v == null) {
                    b.field(f, "50.0m");
                } else {
                    b.field(f, v.toString());
                }
            }, Objects::toString);
            this.pointsOnly.setSerializer((b, f, v) -> {
                if (v == null) {
                    b.field(f, this.strategy.get() == SpatialStrategy.TERM);
                } else {
                    b.field(f, v);
                }
            }, Objects::toString);
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.ignoreMalformed, this.ignoreZValue, this.coerce, this.orientation, this.strategy, this.tree, this.treeLevels, this.precision, this.distanceErrorPct, this.pointsOnly, this.meta);
        }

        public Builder coerce(boolean coerce) {
            this.coerce.setValue(new Explicit<Boolean>(coerce, true));
            return this;
        }

        private void setupFieldTypeDeprecatedParameters(GeoShapeFieldType ft) {
            ft.setStrategy(this.strategy.get());
            ft.setTree(this.tree.get());
            if (this.treeLevels.get() != null) {
                ft.setTreeLevels(this.treeLevels.get());
            }
            if (this.precision.get() != null) {
                ft.setPrecisionInMeters(this.precision.get().value);
            }
            if (this.pointsOnly.get() != null) {
                ft.setPointsOnly(this.pointsOnly.get());
            }
            if (this.distanceErrorPct.get() != null) {
                ft.setDistanceErrorPct(this.distanceErrorPct.get());
            }
            if (ft.treeLevels() == 0 && ft.precisionInMeters() < 0.0) {
                ft.setDefaultDistanceErrorPct(0.025);
            }
        }

        private void setupPrefixTrees(GeoShapeFieldType ft) {
            GeohashPrefixTree prefixTree;
            if (ft.tree().equals("geohash")) {
                prefixTree = new GeohashPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, Builder.getLevels(ft.treeLevels(), ft.precisionInMeters(), Defaults.GEOHASH_TREE_LEVELS, true));
            } else if (ft.tree().equals("legacyquadtree")) {
                prefixTree = new QuadPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, Builder.getLevels(ft.treeLevels(), ft.precisionInMeters(), Defaults.QUADTREE_LEVELS, false));
            } else if (ft.tree().equals("quadtree")) {
                prefixTree = new PackedQuadPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, Builder.getLevels(ft.treeLevels(), ft.precisionInMeters(), Defaults.QUADTREE_LEVELS, false));
            } else {
                throw new IllegalArgumentException("Unknown prefix tree type [" + ft.tree() + "]");
            }
            RecursivePrefixTreeStrategy rpts = new RecursivePrefixTreeStrategy((SpatialPrefixTree)prefixTree, ft.name());
            rpts.setDistErrPct(ft.distanceErrorPct());
            rpts.setPruneLeafyBranches(false);
            ft.recursiveStrategy = rpts;
            TermQueryPrefixTreeStrategy termStrategy = new TermQueryPrefixTreeStrategy((SpatialPrefixTree)prefixTree, ft.name());
            termStrategy.setDistErrPct(ft.distanceErrorPct());
            ft.termStrategy = termStrategy;
            ft.defaultPrefixTreeStrategy = ft.resolvePrefixTreeStrategy(ft.strategy());
            ft.defaultPrefixTreeStrategy.setPointsOnly(ft.pointsOnly());
        }

        private GeoShapeFieldType buildFieldType(LegacyGeoShapeParser parser, ContentPath contentPath) {
            GeoShapeFieldType ft = new GeoShapeFieldType(this.buildFullName(contentPath), (boolean)this.indexed.get(), this.orientation.get().value(), parser, this.meta.get());
            this.setupFieldTypeDeprecatedParameters(ft);
            this.setupPrefixTrees(ft);
            return ft;
        }

        private static int getLevels(int treeLevels, double precisionInMeters, int defaultLevels, boolean geoHash) {
            if (treeLevels > 0 || precisionInMeters >= 0.0) {
                return Math.max(treeLevels, precisionInMeters >= 0.0 ? (geoHash ? GeoUtils.geoHashLevelsForPrecision(precisionInMeters) : GeoUtils.quadTreeLevelsForPrecision(precisionInMeters)) : 0);
            }
            return defaultLevels;
        }

        @Override
        public LegacyGeoShapeFieldMapper build(ContentPath contentPath) {
            if (this.name.isEmpty()) {
                throw new IllegalArgumentException("name cannot be empty string");
            }
            LegacyGeoShapeParser parser = new LegacyGeoShapeParser();
            GeoShapeFieldType ft = this.buildFieldType(parser, contentPath);
            return new LegacyGeoShapeFieldMapper(this.name, ft, this.multiFieldsBuilder.build(this, contentPath), this.copyTo.build(), new LegacyGeoShapeIndexer(ft), parser, this);
        }
    }

    public static final class GeoShapeFieldType
    extends AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType
    implements GeoShapeQueryable {
        private String tree = "quadtree";
        private SpatialStrategy strategy = Defaults.STRATEGY;
        private boolean pointsOnly = false;
        private int treeLevels = 0;
        private double precisionInMeters = -1.0;
        private Double distanceErrorPct;
        private double defaultDistanceErrorPct = 0.0;
        private PrefixTreeStrategy defaultPrefixTreeStrategy;
        private RecursivePrefixTreeStrategy recursiveStrategy;
        private TermQueryPrefixTreeStrategy termStrategy;
        private final LegacyGeoShapeQueryProcessor queryProcessor = new LegacyGeoShapeQueryProcessor(this);

        private GeoShapeFieldType(String name, boolean indexed, ShapeBuilder.Orientation orientation, LegacyGeoShapeParser parser, Map<String, String> meta) {
            super(name, indexed, false, false, false, parser, orientation, meta);
        }

        public GeoShapeFieldType(String name) {
            this(name, true, ShapeBuilder.Orientation.RIGHT, null, Collections.emptyMap());
        }

        @Override
        public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, SearchExecutionContext context) {
            throw new UnsupportedOperationException("process method should not be called for PrefixTree based geo_shapes");
        }

        @Override
        public Query geoShapeQuery(Geometry shape, String fieldName, SpatialStrategy strategy, ShapeRelation relation, SearchExecutionContext context) {
            return this.queryProcessor.geoShapeQuery(shape, fieldName, strategy, relation, context);
        }

        @Override
        public String typeName() {
            return LegacyGeoShapeFieldMapper.CONTENT_TYPE;
        }

        public String tree() {
            return this.tree;
        }

        public void setTree(String tree) {
            this.tree = tree;
        }

        public SpatialStrategy strategy() {
            return this.strategy;
        }

        public void setStrategy(SpatialStrategy strategy) {
            this.strategy = strategy;
            if (this.strategy.equals(SpatialStrategy.TERM)) {
                this.pointsOnly = true;
            }
        }

        public boolean pointsOnly() {
            return this.pointsOnly;
        }

        public void setPointsOnly(boolean pointsOnly) {
            this.pointsOnly = pointsOnly;
        }

        public int treeLevels() {
            return this.treeLevels;
        }

        public void setTreeLevels(int treeLevels) {
            this.treeLevels = treeLevels;
        }

        public double precisionInMeters() {
            return this.precisionInMeters;
        }

        public void setPrecisionInMeters(double precisionInMeters) {
            this.precisionInMeters = precisionInMeters;
        }

        public double distanceErrorPct() {
            return this.distanceErrorPct == null ? this.defaultDistanceErrorPct : this.distanceErrorPct;
        }

        public void setDistanceErrorPct(double distanceErrorPct) {
            this.distanceErrorPct = distanceErrorPct;
        }

        public void setDefaultDistanceErrorPct(double defaultDistanceErrorPct) {
            this.defaultDistanceErrorPct = defaultDistanceErrorPct;
        }

        public PrefixTreeStrategy defaultPrefixTreeStrategy() {
            return this.defaultPrefixTreeStrategy;
        }

        public PrefixTreeStrategy resolvePrefixTreeStrategy(SpatialStrategy strategy) {
            return this.resolvePrefixTreeStrategy(strategy.getStrategyName());
        }

        public PrefixTreeStrategy resolvePrefixTreeStrategy(String strategyName) {
            if (SpatialStrategy.RECURSIVE.getStrategyName().equals(strategyName)) {
                return this.recursiveStrategy;
            }
            if (SpatialStrategy.TERM.getStrategyName().equals(strategyName)) {
                return this.termStrategy;
            }
            throw new IllegalArgumentException("Unknown prefix tree strategy [" + strategyName + "]");
        }
    }

    private static class LegacyGeoShapeParser
    extends AbstractGeometryFieldMapper.Parser<ShapeBuilder<?, ?, ?>> {
        private final GeometryParser geometryParser = new GeometryParser(true, true, true);

        private LegacyGeoShapeParser() {
        }

        @Override
        public ShapeBuilder<?, ?, ?> parse(XContentParser parser) throws IOException, ParseException {
            return ShapeParser.parse(parser);
        }

        @Override
        public Object format(ShapeBuilder<?, ?, ?> value, String format) {
            Object geometry = value.buildGeometry();
            return this.geometryParser.geometryFormat(format).toXContentAsObject((Geometry)geometry);
        }
    }

    public static class PrefixTrees {
        public static final String LEGACY_QUADTREE = "legacyquadtree";
        public static final String QUADTREE = "quadtree";
        public static final String GEOHASH = "geohash";
    }

    public static class Defaults {
        public static final SpatialStrategy STRATEGY = SpatialStrategy.RECURSIVE;
        public static final String TREE = "quadtree";
        public static final String PRECISION = "50m";
        public static final int QUADTREE_LEVELS = GeoUtils.quadTreeLevelsForPrecision("50m");
        public static final int GEOHASH_TREE_LEVELS = GeoUtils.geoHashLevelsForPrecision("50m");
        public static final boolean POINTS_ONLY = false;
        public static final double DISTANCE_ERROR_PCT = 0.025;

        public static int defaultTreeLevel(String tree) {
            switch (tree) {
                case "geohash": {
                    return GEOHASH_TREE_LEVELS;
                }
                case "legacyquadtree": 
                case "quadtree": {
                    return QUADTREE_LEVELS;
                }
            }
            throw new IllegalArgumentException("Unknown prefix type [" + tree + "]");
        }
    }
}

