/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParser;
import org.elasticsearch.index.mapper.TextSearchInfo;

public abstract class RuntimeFieldType
extends MappedFieldType
implements ToXContentFragment {
    protected RuntimeFieldType(String name, Map<String, String> meta) {
        super(name, false, false, false, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
    }

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name());
        builder.field("type", this.typeName());
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        this.doXContentBody(builder, includeDefaults);
        builder.endObject();
        return builder;
    }

    protected abstract void doXContentBody(XContentBuilder var1, boolean var2) throws IOException;

    public static Map<String, RuntimeFieldType> parseRuntimeFields(Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext, boolean supportsRemoval) {
        HashMap<String, RuntimeFieldType> runtimeFields = new HashMap<String, RuntimeFieldType>();
        Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String fieldName = entry.getKey();
            if (entry.getValue() == null) {
                if (supportsRemoval) {
                    runtimeFields.put(fieldName, null);
                    continue;
                }
                throw new MapperParsingException("Runtime field [" + fieldName + "] was set to null but its removal is not supported in this context");
            }
            if (entry.getValue() instanceof Map) {
                HashMap<String, Object> propNode = new HashMap<String, Object>((Map)entry.getValue());
                Object typeNode = propNode.get("type");
                if (typeNode == null) {
                    throw new MapperParsingException("No type specified for runtime field [" + fieldName + "]");
                }
                String type = typeNode.toString();
                Parser typeParser = parserContext.runtimeFieldTypeParser(type);
                if (typeParser == null) {
                    throw new MapperParsingException("No handler for type [" + type + "] declared on runtime field [" + fieldName + "]");
                }
                runtimeFields.put(fieldName, typeParser.parse(fieldName, propNode, parserContext));
                propNode.remove("type");
                MappingParser.checkNoRemainingFields(fieldName, propNode);
                iterator.remove();
                continue;
            }
            throw new MapperParsingException("Expected map for runtime field [" + fieldName + "] definition but got a " + entry.getValue().getClass().getName());
        }
        return Collections.unmodifiableMap(runtimeFields);
    }

    public static interface Parser {
        public RuntimeFieldType parse(String var1, Map<String, Object> var2, Mapper.TypeParser.ParserContext var3) throws MapperParsingException;
    }
}

