/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.function.LongSupplier;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.shard.IndexLongFieldRange;

public class CoordinatorRewriteContext
extends QueryRewriteContext {
    private final Index index;
    private IndexLongFieldRange indexLongFieldRange;
    private final DateFieldMapper.DateFieldType timestampFieldType;

    public CoordinatorRewriteContext(NamedXContentRegistry xContentRegistry, NamedWriteableRegistry writeableRegistry, Client client, LongSupplier nowInMillis, Index index, IndexLongFieldRange indexLongFieldRange, DateFieldMapper.DateFieldType timestampFieldType) {
        super(xContentRegistry, writeableRegistry, client, nowInMillis);
        this.index = index;
        this.indexLongFieldRange = indexLongFieldRange;
        this.timestampFieldType = timestampFieldType;
    }

    long getMinTimestamp() {
        return this.indexLongFieldRange.getMin();
    }

    long getMaxTimestamp() {
        return this.indexLongFieldRange.getMax();
    }

    boolean hasTimestampData() {
        return this.indexLongFieldRange.isComplete() && this.indexLongFieldRange != IndexLongFieldRange.EMPTY;
    }

    @Nullable
    public MappedFieldType getFieldType(String fieldName) {
        if (!fieldName.equals(this.timestampFieldType.name())) {
            return null;
        }
        return this.timestampFieldType;
    }

    @Override
    public CoordinatorRewriteContext convertToCoordinatorRewriteContext() {
        return this;
    }
}

