/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action;

import java.util.concurrent.ExecutorService;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestActionListener;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.tasks.TaskCancelledException;

public class DispatchingRestToXContentListener<Response extends ToXContentObject>
extends RestActionListener<Response> {
    private final ExecutorService executor;
    private final RestRequest restRequest;

    public DispatchingRestToXContentListener(ExecutorService executor, RestChannel channel, RestRequest restRequest) {
        super(channel);
        this.executor = executor;
        this.restRequest = restRequest;
    }

    private void ensureOpen() {
        if (!this.restRequest.getHttpChannel().isOpen()) {
            throw new TaskCancelledException("response channel [" + this.restRequest.getHttpChannel() + "] closed");
        }
    }

    protected ToXContent.Params getParams() {
        return this.restRequest;
    }

    @Override
    protected void processResponse(Response response) {
        this.ensureOpen();
        this.executor.execute(ActionRunnable.wrap(this, l -> new RestBuilderListener<Response>(this.channel){

            @Override
            public RestResponse buildResponse(Response response, XContentBuilder builder) throws Exception {
                DispatchingRestToXContentListener.this.ensureOpen();
                response.toXContent(builder, DispatchingRestToXContentListener.this.getParams());
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        }.onResponse(response)));
    }
}

