/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.rest.action.document.RestTermVectorsAction;

public class RestMultiTermVectorsAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestTermVectorsAction.class);
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in multi term vector requests is deprecated.";

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_mtermvectors"), new RestHandler.Route(RestRequest.Method.POST, "/_mtermvectors"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mtermvectors"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mtermvectors"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/{type}/_mtermvectors"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/{type}/_mtermvectors")));
    }

    @Override
    public String getName() {
        return "document_multi_term_vectors_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MultiTermVectorsRequest multiTermVectorsRequest = new MultiTermVectorsRequest();
        TermVectorsRequest template = (TermVectorsRequest)new TermVectorsRequest().index(request.param("index"));
        if (request.hasParam("type")) {
            deprecationLogger.deprecate(DeprecationCategory.TYPES, "mtermvectors_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
            template.type(request.param("type"));
        } else {
            template.type("_doc");
        }
        RestTermVectorsAction.readURIParameters(template, request);
        multiTermVectorsRequest.ids(Strings.commaDelimitedListToStringArray(request.param("ids")));
        request.withContentOrSourceParamParserOrNull((CheckedConsumer<XContentParser, IOException>)((CheckedConsumer)p -> multiTermVectorsRequest.add(template, (XContentParser)p)));
        return channel -> client.multiTermVectors(multiTermVectorsRequest, new RestToXContentListener<MultiTermVectorsResponse>((RestChannel)channel));
    }
}

