/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.List;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedAggregatorSupplier;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedNumericSamplerAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.SamplerAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.UnmappedSampler;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class DiversifiedAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final DiversifiedAggregatorSupplier aggregatorSupplier;
    private final int shardSize;
    private final int maxDocsPerValue;
    private final String executionHint;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(DiversifiedAggregationBuilder.REGISTRY_KEY, List.of((Object[])new ValuesSourceType[]{CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN}), (name, shardSize, factories, context, parent, metadata, valuesSourceConfig, maxDocsPerValue, executionHint) -> new DiversifiedNumericSamplerAggregator(name, shardSize, factories, context, parent, metadata, valuesSourceConfig, maxDocsPerValue), true);
        builder.register(DiversifiedAggregationBuilder.REGISTRY_KEY, CoreValuesSourceType.KEYWORD, (name, shardSize, factories, context, parent, metadata, valuesSourceConfig, maxDocsPerValue, executionHint) -> {
            SamplerAggregator.ExecutionMode execution = null;
            if (executionHint != null) {
                execution = SamplerAggregator.ExecutionMode.fromString(executionHint);
            }
            if (execution == null) {
                execution = SamplerAggregator.ExecutionMode.GLOBAL_ORDINALS;
            }
            if (execution.needsGlobalOrdinals() && !valuesSourceConfig.hasGlobalOrdinals()) {
                execution = SamplerAggregator.ExecutionMode.MAP;
            }
            return execution.create(name, factories, shardSize, maxDocsPerValue, valuesSourceConfig, context, parent, metadata);
        }, true);
    }

    DiversifiedAggregatorFactory(String name, ValuesSourceConfig config, int shardSize, int maxDocsPerValue, String executionHint, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, DiversifiedAggregatorSupplier aggregatorSupplier) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.shardSize = shardSize;
        this.maxDocsPerValue = maxDocsPerValue;
        this.executionHint = executionHint;
        this.aggregatorSupplier = aggregatorSupplier;
    }

    @Override
    protected Aggregator doCreateInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.aggregatorSupplier.build(this.name, this.shardSize, this.factories, this.context, parent, metadata, this.config, this.maxDocsPerValue, this.executionHint);
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        final UnmappedSampler aggregation = new UnmappedSampler(this.name, metadata);
        return new NonCollectingAggregator(this.name, this.context, parent, this.factories, metadata){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }
}

