/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector.database;

import java.sql.Connection;
import org.dbsyncer.sdk.SdkException;
import org.dbsyncer.sdk.config.DatabaseConfig;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.dbsyncer.sdk.connector.database.DatabaseTemplate;
import org.dbsyncer.sdk.connector.database.HandleCallback;
import org.dbsyncer.sdk.connector.database.ds.SimpleConnection;
import org.dbsyncer.sdk.connector.database.ds.SimpleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;

public class DatabaseConnectorInstance
implements ConnectorInstance<DatabaseConfig, Connection> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DatabaseConfig config;
    private SimpleDataSource dataSource;

    public DatabaseConnectorInstance(DatabaseConfig config) {
        this.config = config;
        this.dataSource = new SimpleDataSource(config.getDriverClassName(), config.getUrl(), config.getUsername(), config.getPassword());
    }

    public <T> T execute(HandleCallback callback) {
        Connection connection = null;
        try {
            connection = this.getConnection();
            Object object = callback.apply(new DatabaseTemplate((SimpleConnection)connection));
            return (T)object;
        }
        catch (EmptyResultDataAccessException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new SdkException(e.getMessage(), e.getCause());
        }
        finally {
            this.dataSource.close(connection);
        }
    }

    @Override
    public String getServiceUrl() {
        return this.config.getUrl();
    }

    @Override
    public DatabaseConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(DatabaseConfig config) {
        this.config = config;
    }

    @Override
    public Connection getConnection() throws Exception {
        return this.dataSource.getConnection();
    }

    @Override
    public void close() {
        this.dataSource.close();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

