/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector.database.sqlbuilder;

import java.util.List;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.sdk.config.SqlBuilderConfig;
import org.dbsyncer.sdk.connector.database.Database;
import org.dbsyncer.sdk.connector.database.sqlbuilder.SqlBuilderQuery;
import org.dbsyncer.sdk.util.PrimaryKeyUtil;

public class SqlBuilderQueryCount
extends SqlBuilderQuery {
    @Override
    public String buildSql(SqlBuilderConfig config) {
        Database database = config.getDatabase();
        String quotation = database.buildSqlWithQuotation();
        String tableName = config.getTableName();
        List<String> primaryKeys = database.buildPrimaryKeys(config.getPrimaryKeys());
        String schema = config.getSchema();
        String queryFilter = config.getQueryFilter();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT COUNT(1) FROM (SELECT 1 AS ").append(quotation).append("_ROW").append(quotation).append(" FROM ");
        sql.append(schema);
        sql.append(quotation);
        sql.append(database.buildTableName(tableName));
        sql.append(quotation);
        if (StringUtil.isNotBlank((CharSequence)queryFilter)) {
            sql.append(queryFilter);
        }
        sql.append(" GROUP BY ");
        PrimaryKeyUtil.buildSql(sql, primaryKeys, quotation, ",", "", true);
        sql.append(") DBSYNCER_T");
        return sql.toString();
    }
}

