/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector.schema;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.dbsyncer.sdk.SdkException;
import org.dbsyncer.sdk.connector.AbstractValueMapper;
import org.dbsyncer.sdk.connector.ConnectorInstance;

public class BigintValueMapper
extends AbstractValueMapper<Long> {
    @Override
    protected Long convert(ConnectorInstance connectorInstance, Object val) {
        if (val instanceof BigDecimal) {
            BigDecimal bitDec = (BigDecimal)val;
            return bitDec.longValue();
        }
        if (val instanceof BigInteger) {
            BigInteger bitInt = (BigInteger)val;
            return bitInt.longValue();
        }
        if (val instanceof Integer) {
            return new Long(((Integer)val).intValue());
        }
        if (val instanceof String) {
            return new Long((String)val);
        }
        throw new SdkException(String.format("%s can not find type [%s], val [%s]", this.getClass().getSimpleName(), val.getClass(), val));
    }
}

