/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector.schema;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.dbsyncer.sdk.SdkException;
import org.dbsyncer.sdk.connector.AbstractValueMapper;
import org.dbsyncer.sdk.connector.ConnectorInstance;

public class BitValueMapper
extends AbstractValueMapper<byte[]> {
    @Override
    protected byte[] convert(ConnectorInstance connectorInstance, Object val) {
        if (val instanceof BitSet) {
            BitSet bitSet = (BitSet)val;
            return bitSet.toByteArray();
        }
        if (val instanceof Integer) {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt((Integer)val);
            return buffer.array();
        }
        if (val instanceof Boolean) {
            Boolean b = (Boolean)val;
            ByteBuffer buffer = ByteBuffer.allocate(2);
            buffer.putShort((short)(b != false ? 1 : 0));
            return buffer.array();
        }
        throw new SdkException(String.format("%s can not find type [%s], val [%s]", this.getClass().getSimpleName(), val.getClass(), val));
    }
}

