/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector.schema;

import java.math.BigDecimal;
import org.dbsyncer.sdk.SdkException;
import org.dbsyncer.sdk.connector.AbstractValueMapper;
import org.dbsyncer.sdk.connector.ConnectorInstance;

public class FloatValueMapper
extends AbstractValueMapper<Float> {
    @Override
    protected Float convert(ConnectorInstance connectorInstance, Object val) {
        if (val instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)val;
            return Float.valueOf(bigDecimal.floatValue());
        }
        if (val instanceof Double) {
            Double dbl = (Double)val;
            return Float.valueOf(dbl.floatValue());
        }
        if (val instanceof String) {
            String strVal = (String)val;
            return Float.valueOf(Float.parseFloat(strVal));
        }
        throw new SdkException(String.format("%s can not find type [%s], val [%s]", this.getClass().getSimpleName(), val.getClass(), val));
    }
}

