/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector.schema;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.dbsyncer.sdk.SdkException;
import org.dbsyncer.sdk.connector.AbstractValueMapper;
import org.dbsyncer.sdk.connector.ConnectorInstance;

public class IntegerValueMapper
extends AbstractValueMapper<Integer> {
    @Override
    protected Integer convert(ConnectorInstance connectorInstance, Object val) {
        if (val instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)val;
            return bigInteger.intValue();
        }
        if (val instanceof Long) {
            Long l = (Long)val;
            return l.intValue();
        }
        if (val instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)val;
            return bigDecimal.intValue();
        }
        if (val instanceof Boolean) {
            Boolean b = (Boolean)val;
            return new Integer(b != false ? 1 : 0);
        }
        throw new SdkException(String.format("%s can not find type [%s], val [%s]", this.getClass().getSimpleName(), val.getClass(), val));
    }
}

