/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector.schema;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Date;
import oracle.sql.TIMESTAMP;
import org.dbsyncer.common.util.DateFormatUtil;
import org.dbsyncer.sdk.SdkException;
import org.dbsyncer.sdk.connector.AbstractValueMapper;
import org.dbsyncer.sdk.connector.ConnectorInstance;

public class TimestampValueMapper
extends AbstractValueMapper<Timestamp> {
    @Override
    protected Timestamp convert(ConnectorInstance connectorInstance, Object val) throws SQLException {
        Comparable<Date> date;
        byte[] bytes;
        String s;
        Timestamp timestamp;
        String s2;
        Timestamp timestamp2;
        if (val instanceof java.sql.Date) {
            java.sql.Date date2 = (java.sql.Date)val;
            return new Timestamp(date2.getTime());
        }
        if (val instanceof LocalDateTime) {
            LocalDateTime dateTime = (LocalDateTime)val;
            return Timestamp.valueOf(dateTime);
        }
        if (val instanceof String && null != (timestamp2 = DateFormatUtil.stringToTimestamp((String)(s2 = (String)val)))) {
            return timestamp2;
        }
        if (val instanceof byte[] && null != (timestamp = DateFormatUtil.stringToTimestamp((String)(s = new String(bytes = (byte[])val))))) {
            return timestamp;
        }
        if (val instanceof Date) {
            date = (Date)val;
            return new Timestamp(((Date)date).getTime());
        }
        if (val instanceof TIMESTAMP) {
            TIMESTAMP timestamp3 = (TIMESTAMP)val;
            return timestamp3.timestampValue();
        }
        if (val instanceof OffsetDateTime) {
            date = (OffsetDateTime)val;
            return Timestamp.from(((OffsetDateTime)date).toInstant());
        }
        throw new SdkException(String.format("%s can not find type [%s], val [%s]", this.getClass().getSimpleName(), val.getClass(), val));
    }
}

