/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.enums;

import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.sdk.SdkException;

public enum ModelEnum {
    FULL("full", "\u5168\u91cf"),
    INCREMENT("increment", "\u589e\u91cf");

    private String code;
    private String name;

    private ModelEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static ModelEnum getModelEnum(String code) throws SdkException {
        for (ModelEnum e : ModelEnum.values()) {
            if (!StringUtil.equals((CharSequence)code, (CharSequence)e.getCode())) continue;
            return e;
        }
        throw new SdkException(String.format("Model code \"%s\" does not exist.", code));
    }

    public static boolean isFull(String model) {
        return StringUtil.equals((CharSequence)FULL.getCode(), (CharSequence)model);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

