/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.enums;

import org.dbsyncer.sdk.SdkException;
import org.dbsyncer.sdk.enums.StorageEnum;
import org.dbsyncer.sdk.storage.Strategy;
import org.dbsyncer.sdk.storage.strategy.ConfigStrategy;
import org.dbsyncer.sdk.storage.strategy.DataStrategy;
import org.dbsyncer.sdk.storage.strategy.LogStrategy;

public enum StorageStrategyEnum {
    CONFIG(StorageEnum.CONFIG, new ConfigStrategy()),
    DATA(StorageEnum.DATA, new DataStrategy()),
    LOG(StorageEnum.LOG, new LogStrategy());

    private StorageEnum type;
    private Strategy strategy;

    private StorageStrategyEnum(StorageEnum type, Strategy strategy) {
        this.type = type;
        this.strategy = strategy;
    }

    public static Strategy getStrategy(StorageEnum type) throws SdkException {
        for (StorageStrategyEnum e : StorageStrategyEnum.values()) {
            if (type != e.getType()) continue;
            return e.getStrategy();
        }
        throw new SdkException(String.format("StorageStrategy type \"%s\" does not exist.", new Object[]{type}));
    }

    public StorageEnum getType() {
        return this.type;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }
}

