/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.sdk.connector.database.AbstractDatabaseConnector;
import org.dbsyncer.sdk.connector.database.DatabaseConnectorInstance;
import org.dbsyncer.sdk.listener.AbstractListener;
import org.dbsyncer.sdk.listener.ChangedEvent;
import org.dbsyncer.sdk.listener.event.RowChangedEvent;
import org.dbsyncer.sdk.model.Field;
import org.dbsyncer.sdk.model.MetaInfo;
import org.dbsyncer.sdk.model.Table;
import org.dbsyncer.sdk.util.PrimaryKeyUtil;
import org.springframework.util.Assert;

public abstract class AbstractDatabaseListener
extends AbstractListener<DatabaseConnectorInstance> {
    private Map<String, List<DqlMapper>> dqlMap = new ConcurrentHashMap<String, List<DqlMapper>>();

    protected void sendChangedEvent(ChangedEvent event) {
        this.changeEvent(event);
    }

    protected void sendDqlChangedEvent(ChangedEvent event) {
        if (null == event) {
            return;
        }
        List<DqlMapper> dqlMappers = this.dqlMap.get(event.getSourceTableName());
        if (CollectionUtils.isEmpty(dqlMappers)) {
            return;
        }
        RowChangedEvent changedEvent = (RowChangedEvent)event;
        boolean processed = false;
        for (DqlMapper dqlMapper : dqlMappers) {
            if (!processed) {
                switch (event.getEvent()) {
                    case "UPDATE": 
                    case "INSERT": {
                        this.queryDqlData(dqlMapper, changedEvent.getDataList());
                        break;
                    }
                }
                processed = true;
            }
            changedEvent.setSourceTableName(dqlMapper.sqlName);
            this.changeEvent(changedEvent);
        }
    }

    protected void postProcessDqlBeforeInitialization() {
        DatabaseConnectorInstance instance = (DatabaseConnectorInstance)this.connectorInstance;
        AbstractDatabaseConnector service = (AbstractDatabaseConnector)this.connectorService;
        String quotation = service.buildSqlWithQuotation();
        HashMap tableMap = new HashMap();
        instance.getConfig().getSqlTables().forEach(s -> tableMap.put(s.getSqlName(), s.getTable()));
        this.filterTable.clear();
        for (Table t : this.sourceTable) {
            String sql = t.getSql();
            String sqlName = t.getName();
            List<String> primaryKeys = PrimaryKeyUtil.findTablePrimaryKeys(t);
            String tableName = (String)tableMap.get(sqlName);
            Assert.hasText((String)sql, (String)"The sql is null.");
            Assert.hasText((String)tableName, (String)"The tableName is null.");
            MetaInfo metaInfo = service.getMetaInfo(instance, sqlName);
            List<Field> column = metaInfo.getColumn();
            Assert.notEmpty(column, (String)String.format("The column of table name '%s' is empty.", sqlName));
            sql = sql.toUpperCase().replace("\t", " ");
            sql = sql.replace("\r", " ");
            sql = sql.replace("\n", " ");
            StringBuilder querySql = new StringBuilder(sql);
            boolean notContainsWhere = !StringUtil.contains((CharSequence)sql, (CharSequence)" WHERE ");
            querySql.append(notContainsWhere ? " WHERE " : " AND ");
            PrimaryKeyUtil.buildSql(querySql, primaryKeys, quotation, " AND ", " = ? ", notContainsWhere);
            DqlMapper dqlMapper = new DqlMapper(instance, sqlName, querySql.toString(), column, this.getPrimaryKeyIndexArray(column, primaryKeys));
            if (!this.dqlMap.containsKey(tableName)) {
                this.dqlMap.putIfAbsent(tableName, new ArrayList());
            }
            this.dqlMap.get(tableName).add(dqlMapper);
            this.filterTable.add(tableName);
        }
    }

    protected Integer[] getPrimaryKeyIndexArray(List<Field> column, List<String> primaryKeys) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (Field f : column) {
            if (!primaryKeys.contains(f.getName())) continue;
            indexList.add(column.indexOf(f));
        }
        Assert.isTrue((!CollectionUtils.isEmpty(indexList) ? 1 : 0) != 0, (String)"The primaryKeys is invalid.");
        Object[] indexArray = indexList.toArray();
        Integer[] newIndexArray = new Integer[indexArray.length];
        System.arraycopy(indexArray, 0, newIndexArray, 0, indexArray.length);
        return newIndexArray;
    }

    private void queryDqlData(DqlMapper dqlMapper, List<Object> data) {
        Map row;
        if (!CollectionUtils.isEmpty(data) && !CollectionUtils.isEmpty((Map)(row = (Map)dqlMapper.instance.execute(databaseTemplate -> {
            int size = dqlMapper.primaryKeyIndexArray.length;
            Object[] args = new Object[size];
            for (int i = 0; i < size; ++i) {
                args[i] = data.get(dqlMapper.primaryKeyIndexArray[i]);
            }
            return databaseTemplate.queryForMap(dqlMapper.sql, args);
        })))) {
            data.clear();
            dqlMapper.column.forEach(field -> data.add(row.get(field.getName())));
        }
    }

    final class DqlMapper {
        DatabaseConnectorInstance instance;
        String sqlName;
        String sql;
        List<Field> column;
        Integer[] primaryKeyIndexArray;

        public DqlMapper(DatabaseConnectorInstance instance, String sqlName, String sql, List<Field> column, Integer[] primaryKeyIndexArray) {
            this.instance = instance;
            this.sqlName = sqlName;
            this.sql = sql;
            this.column = column;
            this.primaryKeyIndexArray = primaryKeyIndexArray;
        }
    }
}

