/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.listener;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dbsyncer.common.model.Result;
import org.dbsyncer.common.scheduled.ScheduledTaskJob;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.common.util.UUIDUtil;
import org.dbsyncer.sdk.config.ReaderConfig;
import org.dbsyncer.sdk.listener.AbstractListener;
import org.dbsyncer.sdk.listener.event.ScanChangedEvent;
import org.dbsyncer.sdk.model.Point;
import org.dbsyncer.sdk.model.Table;
import org.dbsyncer.sdk.model.TableGroupQuartzCommand;
import org.dbsyncer.sdk.util.PrimaryKeyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuartzListener
extends AbstractListener
implements ScheduledTaskJob {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String CURSOR = "cursor";
    private final int READ_NUM = 1000;
    private List<TableGroupQuartzCommand> commands;
    private String eventFieldName;
    private boolean forceUpdate;
    private Set<String> update;
    private Set<String> insert;
    private Set<String> delete;
    private String taskKey;
    private volatile boolean running;
    private final Lock lock = new ReentrantLock();

    protected abstract Point checkLastPoint(Map<String, String> var1, int var2);

    @Override
    public void start() {
        this.eventFieldName = this.listenerConfig.getEventFieldName();
        this.forceUpdate = StringUtil.isBlank((CharSequence)this.listenerConfig.getEventFieldName());
        this.update = Stream.of(this.listenerConfig.getUpdate().split(",")).collect(Collectors.toSet());
        this.insert = Stream.of(this.listenerConfig.getInsert().split(",")).collect(Collectors.toSet());
        this.delete = Stream.of(this.listenerConfig.getDelete().split(",")).collect(Collectors.toSet());
        this.taskKey = UUIDUtil.getUUID();
        this.running = true;
        this.scheduledTaskService.start(this.taskKey, this.listenerConfig.getCron(), (ScheduledTaskJob)this);
        this.logger.info("\u542f\u52a8\u5b9a\u65f6\u4efb\u52a1:{} >> {}", (Object)this.taskKey, (Object)this.listenerConfig.getCron());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Lock taskLock = this.lock;
        boolean locked = false;
        try {
            locked = taskLock.tryLock();
            if (locked) {
                for (int i = 0; i < this.commands.size(); ++i) {
                    this.execute(this.commands.get(i), i);
                }
            }
        }
        catch (Exception e) {
            this.errorEvent(e);
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (locked) {
                taskLock.unlock();
            }
        }
    }

    @Override
    public void close() {
        this.scheduledTaskService.stop(this.taskKey);
        this.running = false;
    }

    private void execute(TableGroupQuartzCommand tableGroupQuartzCommand, int index) {
        Map<String, String> command = tableGroupQuartzCommand.getCommand();
        List<String> primaryKeys = tableGroupQuartzCommand.getPrimaryKeys();
        Table table = tableGroupQuartzCommand.getTable();
        boolean supportedCursor = StringUtil.isNotBlank((CharSequence)command.get("QUERY_CURSOR"));
        Point point = this.checkLastPoint(command, index);
        int pageIndex = 1;
        Object[] cursors = PrimaryKeyUtil.getLastCursors((String)this.snapshot.get(index + "cursor"));
        while (this.running) {
            ReaderConfig readerConfig = new ReaderConfig(table, point.getCommand(), point.getArgs(), supportedCursor, cursors, pageIndex++, 1000);
            Result reader = this.connectorService.reader(this.connectorInstance, readerConfig);
            List data = reader.getSuccessData();
            if (CollectionUtils.isEmpty((Collection)data)) {
                cursors = new Object[]{};
                break;
            }
            for (Map row : data) {
                if (this.forceUpdate) {
                    this.changeEvent(new ScanChangedEvent(index, "UPDATE", row));
                    continue;
                }
                Object eventValue = row.get(this.eventFieldName);
                if (this.update.contains(eventValue)) {
                    this.changeEvent(new ScanChangedEvent(index, "UPDATE", row));
                    continue;
                }
                if (this.insert.contains(eventValue)) {
                    this.changeEvent(new ScanChangedEvent(index, "INSERT", row));
                    continue;
                }
                if (!this.delete.contains(eventValue)) continue;
                this.changeEvent(new ScanChangedEvent(index, "DELETE", row));
            }
            cursors = PrimaryKeyUtil.getLastCursors(data, primaryKeys);
            point.refresh();
            if (data.size() >= 1000) continue;
            cursors = new Object[]{};
            break;
        }
        if (point.refreshed()) {
            this.snapshot.putAll(point.getPosition());
        }
        if (supportedCursor) {
            this.snapshot.put(index + "cursor", StringUtil.join((Object[])cursors, (String)","));
        }
    }

    public void setCommands(List<TableGroupQuartzCommand> commands) {
        this.commands = commands;
    }
}

