/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.sqlserver.cdc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.dbsyncer.common.QueueOverflowException;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.connector.sqlserver.SqlServerException;
import org.dbsyncer.connector.sqlserver.cdc.Lsn;
import org.dbsyncer.connector.sqlserver.cdc.LsnPuller;
import org.dbsyncer.connector.sqlserver.enums.TableOperationEnum;
import org.dbsyncer.connector.sqlserver.model.CDCEvent;
import org.dbsyncer.connector.sqlserver.model.SqlServerChangeTable;
import org.dbsyncer.sdk.config.DatabaseConfig;
import org.dbsyncer.sdk.connector.database.AbstractDatabaseConnector;
import org.dbsyncer.sdk.connector.database.DatabaseConnectorInstance;
import org.dbsyncer.sdk.listener.AbstractDatabaseListener;
import org.dbsyncer.sdk.listener.ChangedEvent;
import org.dbsyncer.sdk.listener.event.RowChangedEvent;
import org.dbsyncer.sdk.model.ChangedOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class SqlServerListener
extends AbstractDatabaseListener {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String STATEMENTS_PLACEHOLDER = "#";
    private static final String GET_DATABASE_NAME = "select db_name()";
    private static final String GET_TABLE_LIST = "select name from sys.tables where schema_id = schema_id('#') and is_ms_shipped = 0";
    private static final String IS_DB_CDC_ENABLED = "select is_cdc_enabled from sys.databases where name = '#'";
    private static final String IS_TABLE_CDC_ENABLED = "select count(*) from sys.tables tb where tb.is_tracked_by_cdc = 1 and tb.name='#'";
    private static final String ENABLE_DB_CDC = "IF EXISTS(select 1 from sys.databases where name = '#' and is_cdc_enabled=0) EXEC sys.sp_cdc_enable_db";
    private static final String ENABLE_TABLE_CDC = "IF EXISTS(select 1 from sys.tables where name = '#' and is_tracked_by_cdc=0) EXEC sys.sp_cdc_enable_table @source_schema = N'%s', @source_name = N'#', @role_name = NULL, @supports_net_changes = 0";
    private static final String GET_TABLES_CDC_ENABLED = "EXEC sys.sp_cdc_help_change_data_capture";
    private static final String GET_MAX_LSN = "select sys.fn_cdc_get_max_lsn()";
    private static final String GET_MIN_LSN = "select sys.fn_cdc_get_min_lsn('#')";
    private static final String GET_INCREMENT_LSN = "select sys.fn_cdc_increment_lsn(?)";
    private static final String GET_ALL_CHANGES_FOR_TABLE = "select * from cdc.[fn_cdc_get_all_changes_#](?, ?, N'all update old') order by [__$start_lsn] ASC, [__$seqval] ASC";
    private static final String LSN_POSITION = "position";
    private static final int OFFSET_COLUMNS = 4;
    private final Lock connectLock = new ReentrantLock();
    private volatile boolean connected;
    private Set<String> tables;
    private Set<SqlServerChangeTable> changeTables;
    private DatabaseConnectorInstance instance;
    private Worker worker;
    private Lsn lastLsn;
    private String serverName;
    private String schema;
    private final int BUFFER_CAPACITY = 256;
    private BlockingQueue<Lsn> buffer = new LinkedBlockingQueue<Lsn>(256);
    private Lock lock = new ReentrantLock(true);
    private Condition isFull = this.lock.newCondition();
    private final Duration pollInterval = Duration.of(500L, ChronoUnit.MILLIS);

    public void start() {
        try {
            this.connectLock.lock();
            if (this.connected) {
                this.logger.error("SqlServerExtractor is already started");
                return;
            }
            this.connected = true;
            this.connect();
            this.readTables();
            Assert.notEmpty(this.tables, (String)"No tables available");
            this.enableDBCDC();
            this.enableTableCDC();
            this.readChangeTables();
            this.readLastLsn();
            this.worker = new Worker();
            this.worker.setName("cdc-parser-" + this.serverName + "_" + this.worker.hashCode());
            this.worker.setDaemon(false);
            this.worker.start();
            LsnPuller.addExtractor(this.metaId, this);
        }
        catch (Exception e) {
            this.close();
            this.logger.error("\u542f\u52a8\u5931\u8d25:{}", (Object)e.getMessage());
            throw new SqlServerException(e);
        }
        finally {
            this.connectLock.unlock();
        }
    }

    public void close() {
        if (this.connected) {
            LsnPuller.removeExtractor(this.metaId);
            if (null != this.worker && !this.worker.isInterrupted()) {
                this.worker.interrupt();
                this.worker = null;
            }
            this.connected = false;
        }
    }

    public void refreshEvent(ChangedOffset offset) {
        if (offset.getPosition() != null) {
            this.snapshot.put(LSN_POSITION, offset.getPosition().toString());
        }
    }

    private void close(AutoCloseable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
    }

    private void connect() {
        this.instance = (DatabaseConnectorInstance)this.connectorInstance;
        AbstractDatabaseConnector service = (AbstractDatabaseConnector)this.connectorService;
        if (service.isAlive(this.instance)) {
            DatabaseConfig cfg = this.instance.getConfig();
            this.serverName = cfg.getUrl();
            this.schema = cfg.getSchema();
        }
    }

    private void readLastLsn() {
        if (!this.snapshot.containsKey(LSN_POSITION)) {
            this.lastLsn = this.queryAndMap(GET_MAX_LSN, rs -> new Lsn(rs.getBytes(1)));
            if (null != this.lastLsn && this.lastLsn.isAvailable()) {
                this.snapshot.put(LSN_POSITION, this.lastLsn.toString());
                super.forceFlushEvent();
                return;
            }
            throw new SqlServerException("No maximum LSN recorded in the database");
        }
        this.lastLsn = Lsn.valueOf((String)this.snapshot.get(LSN_POSITION));
    }

    private void readTables() {
        this.tables = this.queryAndMapList(GET_TABLE_LIST.replace(STATEMENTS_PLACEHOLDER, this.schema), rs -> {
            LinkedHashSet<String> table = new LinkedHashSet<String>();
            while (rs.next()) {
                if (!this.filterTable.contains(rs.getString(1))) continue;
                table.add(rs.getString(1));
            }
            return table;
        });
    }

    private void readChangeTables() {
        this.changeTables = this.queryAndMapList(GET_TABLES_CDC_ENABLED, rs -> {
            HashSet<SqlServerChangeTable> tables = new HashSet<SqlServerChangeTable>();
            while (rs.next()) {
                SqlServerChangeTable changeTable = new SqlServerChangeTable(rs.getString(1), rs.getString(2), rs.getString(3), rs.getInt(4), rs.getBytes(6), rs.getBytes(7), rs.getString(15));
                tables.add(changeTable);
            }
            return tables;
        });
    }

    private void enableTableCDC() {
        if (!CollectionUtils.isEmpty(this.tables)) {
            this.tables.forEach(table -> {
                boolean enabledTableCDC = this.queryAndMap(IS_TABLE_CDC_ENABLED.replace(STATEMENTS_PLACEHOLDER, (CharSequence)table), rs -> rs.getInt(1) > 0);
                if (!enabledTableCDC) {
                    this.execute(String.format(ENABLE_TABLE_CDC.replace(STATEMENTS_PLACEHOLDER, (CharSequence)table), this.schema));
                    Lsn minLsn = this.queryAndMap(GET_MIN_LSN.replace(STATEMENTS_PLACEHOLDER, (CharSequence)table), rs -> new Lsn(rs.getBytes(1)));
                    this.logger.info("\u542f\u7528CDC\u8868[{}]:{}", table, (Object)minLsn.isAvailable());
                }
            });
        }
    }

    private void enableDBCDC() throws InterruptedException {
        String realDatabaseName = this.queryAndMap(GET_DATABASE_NAME, rs -> rs.getString(1));
        boolean enabledCDC = this.queryAndMap(IS_DB_CDC_ENABLED.replace(STATEMENTS_PLACEHOLDER, realDatabaseName), rs -> rs.getBoolean(1));
        if (!enabledCDC) {
            this.execute(ENABLE_DB_CDC.replace(STATEMENTS_PLACEHOLDER, realDatabaseName));
            TimeUnit.SECONDS.sleep(3L);
            enabledCDC = this.queryAndMap(IS_DB_CDC_ENABLED.replace(STATEMENTS_PLACEHOLDER, realDatabaseName), rs -> rs.getBoolean(1));
            Assert.isTrue((boolean)enabledCDC, (String)"Please ensure that the SQL Server Agent is running");
        }
    }

    private void execute(String ... sqlStatements) {
        this.instance.execute(databaseTemplate -> {
            for (String sqlStatement : sqlStatements) {
                if (sqlStatement == null) continue;
                this.logger.info("executing '{}'", (Object)sqlStatement);
                databaseTemplate.execute(sqlStatement);
            }
            return true;
        });
    }

    private void pull(Lsn stopLsn) {
        Lsn startLsn = this.queryAndMap(GET_INCREMENT_LSN, statement -> statement.setBytes(1, this.lastLsn.getBinary()), rs -> Lsn.valueOf(rs.getBytes(1)));
        this.changeTables.forEach(changeTable -> {
            String query = GET_ALL_CHANGES_FOR_TABLE.replace(STATEMENTS_PLACEHOLDER, changeTable.getCaptureInstance());
            List list = this.queryAndMapList(query, statement -> {
                statement.setBytes(1, startLsn.getBinary());
                statement.setBytes(2, stopLsn.getBinary());
            }, rs -> {
                int columnCount = rs.getMetaData().getColumnCount();
                ArrayList<Object> row = null;
                ArrayList<CDCEvent> data = new ArrayList<CDCEvent>();
                while (rs.next()) {
                    int operation = rs.getInt(3);
                    if (TableOperationEnum.isUpdateBefore(operation)) continue;
                    row = new ArrayList<Object>(columnCount - 4);
                    for (int i = 5; i <= columnCount; ++i) {
                        row.add(rs.getObject(i));
                    }
                    data.add(new CDCEvent(changeTable.getTableName(), operation, row));
                }
                return data;
            });
            if (!CollectionUtils.isEmpty((Collection)list)) {
                this.parseEvent(list, stopLsn);
            }
        });
    }

    private void trySendEvent(RowChangedEvent event) {
        while (this.connected) {
            try {
                this.sendChangedEvent((ChangedEvent)event);
                break;
            }
            catch (QueueOverflowException ex) {
                try {
                    TimeUnit.MILLISECONDS.sleep(1L);
                }
                catch (InterruptedException exe) {
                    this.logger.error(exe.getMessage(), (Throwable)exe);
                }
            }
        }
    }

    private void parseEvent(List<CDCEvent> list, Lsn stopLsn) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            boolean isEnd = i == size - 1;
            CDCEvent event = list.get(i);
            if (TableOperationEnum.isUpdateAfter(event.getCode())) {
                this.trySendEvent(new RowChangedEvent(event.getTableName(), "UPDATE", event.getRow(), null, (Object)(isEnd ? stopLsn : null)));
                continue;
            }
            if (TableOperationEnum.isInsert(event.getCode())) {
                this.trySendEvent(new RowChangedEvent(event.getTableName(), "INSERT", event.getRow(), null, (Object)(isEnd ? stopLsn : null)));
                continue;
            }
            if (!TableOperationEnum.isDelete(event.getCode())) continue;
            this.trySendEvent(new RowChangedEvent(event.getTableName(), "DELETE", event.getRow(), null, (Object)(isEnd ? stopLsn : null)));
        }
    }

    private <T> T queryAndMap(String sql, ResultSetMapper<T> mapper) {
        return this.queryAndMap(sql, null, mapper);
    }

    private <T> T queryAndMap(String sql, StatementPreparer statementPreparer, ResultSetMapper<T> mapper) {
        return (T)this.query(sql, statementPreparer, rs -> {
            rs.next();
            return mapper.apply(rs);
        });
    }

    private <T> T queryAndMapList(String sql, ResultSetMapper<T> mapper) {
        return this.queryAndMapList(sql, null, mapper);
    }

    private <T> T queryAndMapList(String sql, StatementPreparer statementPreparer, ResultSetMapper<T> mapper) {
        return this.query(sql, statementPreparer, mapper);
    }

    private <T> T query(String preparedQuerySql, StatementPreparer statementPreparer, ResultSetMapper<T> mapper) {
        Object execute = this.instance.execute(databaseTemplate -> {
            PreparedStatement ps = null;
            ResultSet rs = null;
            Object apply = null;
            try {
                ps = databaseTemplate.getSimpleConnection().prepareStatement(preparedQuerySql);
                if (null != statementPreparer) {
                    statementPreparer.accept(ps);
                }
                rs = ps.executeQuery();
                apply = mapper.apply(rs);
                this.close(rs);
                this.close(ps);
            }
            catch (SQLServerException sQLServerException) {
                this.close(rs);
                this.close(ps);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                this.close(rs);
                this.close(ps);
                {
                    catch (Throwable throwable) {
                        this.close(rs);
                        this.close(ps);
                        throw throwable;
                    }
                }
            }
            return apply;
        });
        return (T)execute;
    }

    public Lsn getMaxLsn() {
        return this.queryAndMap(GET_MAX_LSN, rs -> new Lsn(rs.getBytes(1)));
    }

    public Lsn getLastLsn() {
        return this.lastLsn;
    }

    public void pushStopLsn(Lsn stopLsn) {
        if (this.buffer.contains(stopLsn)) {
            return;
        }
        if (!this.buffer.offer(stopLsn)) {
            try {
                this.lock.lock();
                while (!this.buffer.offer(stopLsn) && this.connected) {
                    this.logger.warn("[{}]\u7f13\u5b58\u961f\u5217\u5bb9\u91cf\u5df2\u8fbe\u4e0a\u9650[{}], \u6b63\u5728\u963b\u585e\u91cd\u8bd5.", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)256);
                    try {
                        this.isFull.await(this.pollInterval.toMillis(), TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    final class Worker
    extends Thread {
        Worker() {
        }

        @Override
        public void run() {
            while (!this.isInterrupted() && SqlServerListener.this.connected) {
                try {
                    Lsn poll;
                    Lsn stopLsn = (Lsn)SqlServerListener.this.buffer.take();
                    while ((poll = (Lsn)SqlServerListener.this.buffer.poll()) != null) {
                        stopLsn = poll;
                    }
                    if (!stopLsn.isAvailable() || stopLsn.compareTo(SqlServerListener.this.lastLsn) <= 0) continue;
                    SqlServerListener.this.pull(stopLsn);
                    SqlServerListener.this.lastLsn = stopLsn;
                    SqlServerListener.this.snapshot.put(SqlServerListener.LSN_POSITION, SqlServerListener.this.lastLsn.toString());
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {
                    if (!SqlServerListener.this.connected) continue;
                    SqlServerListener.this.logger.error(e.getMessage(), (Throwable)e);
                    SqlServerListener.this.sleepInMills(1000L);
                }
            }
        }
    }

    private static interface StatementPreparer {
        public void accept(PreparedStatement var1) throws SQLException;
    }

    private static interface ResultSetMapper<T> {
        public T apply(ResultSet var1) throws SQLException;
    }
}

