/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.dbsyncer.common.model.Result;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.file.FileBitValueMapper;
import org.dbsyncer.connector.file.FileConnectorInstance;
import org.dbsyncer.connector.file.FileException;
import org.dbsyncer.connector.file.cdc.FileListener;
import org.dbsyncer.connector.file.config.FileConfig;
import org.dbsyncer.connector.file.model.FileResolver;
import org.dbsyncer.connector.file.model.FileSchema;
import org.dbsyncer.connector.file.validator.FileConfigValidator;
import org.dbsyncer.sdk.config.CommandConfig;
import org.dbsyncer.sdk.config.ReaderConfig;
import org.dbsyncer.sdk.config.WriterBatchConfig;
import org.dbsyncer.sdk.connector.AbstractConnector;
import org.dbsyncer.sdk.connector.ConfigValidator;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.dbsyncer.sdk.enums.ListenerTypeEnum;
import org.dbsyncer.sdk.listener.Listener;
import org.dbsyncer.sdk.model.Field;
import org.dbsyncer.sdk.model.MetaInfo;
import org.dbsyncer.sdk.model.Table;
import org.dbsyncer.sdk.spi.ConnectorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public final class FileConnector
extends AbstractConnector
implements ConnectorService<FileConnectorInstance, FileConfig> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String TYPE = "File";
    private final String FILE_NAME = "fileName";
    private final String FILE_PATH = "filePath";
    private final FileResolver fileResolver = new FileResolver();
    private final FileConfigValidator configValidator = new FileConfigValidator();

    public FileConnector() {
        this.VALUE_MAPPERS.put(-7, new FileBitValueMapper());
    }

    public String getConnectorType() {
        return "File";
    }

    public boolean isSupportedTiming() {
        return false;
    }

    public boolean isSupportedLog() {
        return true;
    }

    public Class<FileConfig> getConfigClass() {
        return FileConfig.class;
    }

    public ConnectorInstance connect(FileConfig config) {
        return new FileConnectorInstance(config);
    }

    public ConfigValidator getConfigValidator() {
        return this.configValidator;
    }

    public void disconnect(FileConnectorInstance connectorInstance) {
    }

    public boolean isAlive(FileConnectorInstance connectorInstance) {
        String fileDir = connectorInstance.getConnection();
        boolean alive = new File(fileDir).exists();
        if (!alive) {
            this.logger.warn("can not find fileDir:{}", (Object)fileDir);
            return false;
        }
        for (FileSchema fileSchema : connectorInstance.getFileSchemaList()) {
            String filePath = connectorInstance.getFilePath(fileSchema.getFileName());
            if (new File(filePath).exists()) continue;
            this.logger.warn("can not find file:{}", (Object)filePath);
            alive = false;
        }
        return alive;
    }

    public String getConnectorInstanceCacheKey(FileConfig config) {
        String localIP;
        try {
            localIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            this.logger.error(e.getMessage());
            localIP = "127.0.0.1";
        }
        return String.format("%s-%s", localIP, config.getFileDir());
    }

    public List<Table> getTable(FileConnectorInstance connectorInstance) {
        return connectorInstance.getFileSchemaList().stream().map(fileSchema -> new Table(fileSchema.getFileName())).collect(Collectors.toList());
    }

    public MetaInfo getMetaInfo(FileConnectorInstance connectorInstance, String tableName) {
        FileSchema fileSchema = connectorInstance.getFileSchema(tableName);
        return new MetaInfo().setColumn(fileSchema.getFields());
    }

    public long getCount(FileConnectorInstance connectorInstance, Map<String, String> command) {
        AtomicLong count = new AtomicLong();
        FileReader reader = null;
        try {
            reader = new FileReader(new File(command.get("filePath")));
            LineIterator lineIterator = IOUtils.lineIterator((Reader)reader);
            while (lineIterator.hasNext()) {
                lineIterator.next();
                count.addAndGet(1L);
            }
        }
        catch (IOException e) {
            try {
                throw new FileException(e.getCause());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return count.get();
    }

    public Result reader(FileConnectorInstance connectorInstance, ReaderConfig config) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        FileReader reader = null;
        try {
            FileConfig fileConfig = connectorInstance.getConfig();
            FileSchema fileSchema = connectorInstance.getFileSchema((String)config.getCommand().get("fileName"));
            List<Field> fields = fileSchema.getFields();
            Assert.notEmpty(fields, (String)"The fields of file schema is empty.");
            char separator = fileConfig.getSeparator();
            reader = new FileReader(new File((String)config.getCommand().get("filePath")));
            LineIterator lineIterator = IOUtils.lineIterator((Reader)reader);
            int from = (config.getPageIndex() - 1) * config.getPageSize();
            int to = from + config.getPageSize();
            AtomicLong count = new AtomicLong();
            while (lineIterator.hasNext()) {
                if (count.get() >= (long)from && count.get() < (long)to) {
                    list.add(this.fileResolver.parseMap(fields, separator, lineIterator.next()));
                } else {
                    lineIterator.next();
                }
                count.addAndGet(1L);
                if (count.get() < (long)to) continue;
            }
        }
        catch (IOException e) {
            try {
                throw new FileException(e.getCause());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return new Result(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result writer(FileConnectorInstance connectorInstance, WriterBatchConfig config) {
        List data = config.getData();
        if (CollectionUtils.isEmpty((Collection)data)) {
            this.logger.error("writer data can not be empty.");
            throw new FileException("writer data can not be empty.");
        }
        List fields = config.getFields();
        String separator = new String(new char[]{connectorInstance.getConfig().getSeparator()});
        Result result = new Result();
        FileOutputStream output = null;
        try {
            String filePath = connectorInstance.getFilePath((String)config.getCommand().get("fileName"));
            output = new FileOutputStream(filePath, true);
            List lines = data.stream().map(row -> {
                ArrayList array = new ArrayList();
                fields.forEach(field -> {
                    Object o = row.get(field.getName());
                    array.add(null != o ? String.valueOf(o) : "");
                });
                return StringUtil.join((Object[])array.toArray(), (String)separator);
            }).collect(Collectors.toList());
            IOUtils.writeLines(lines, (String)System.lineSeparator(), (OutputStream)output, (String)"UTF-8");
        }
        catch (Exception e) {
            try {
                result.addFailData(data);
                result.getError().append(e.getMessage()).append(System.lineSeparator());
                this.logger.error(e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(output);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)output);
        }
        IOUtils.closeQuietly((OutputStream)output);
        return result;
    }

    public Map<String, String> getSourceCommand(CommandConfig commandConfig) {
        HashMap<String, String> command = new HashMap<String, String>();
        FileConfig fileConfig = (FileConfig)commandConfig.getConnectorConfig();
        String fileDir = fileConfig.getFileDir();
        StringBuilder file = new StringBuilder(fileDir);
        if (!StringUtil.endsWith((CharSequence)fileDir, (CharSequence)File.separator)) {
            file.append(File.separator);
        }
        file.append(commandConfig.getTable().getName());
        command.put("filePath", file.toString());
        command.put("fileName", commandConfig.getTable().getName());
        return command;
    }

    public Map<String, String> getTargetCommand(CommandConfig commandConfig) {
        HashMap<String, String> command = new HashMap<String, String>();
        command.put("fileName", commandConfig.getTable().getName());
        return command;
    }

    public Listener getListener(String listenerType) {
        if (ListenerTypeEnum.isLog((String)listenerType)) {
            return new FileListener();
        }
        return null;
    }
}

