/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.file.column.impl;

import java.sql.Date;
import java.sql.Timestamp;
import org.dbsyncer.common.util.DateFormatUtil;
import org.dbsyncer.common.util.NumberUtil;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.file.column.ColumnValue;

public class FileColumnValue
implements ColumnValue {
    private String value;

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public String asString() {
        return this.value;
    }

    @Override
    public Boolean asBoolean() {
        return "true".equalsIgnoreCase(this.value);
    }

    @Override
    public Integer asInteger() {
        return Integer.valueOf(this.value);
    }

    @Override
    public Long asLong() {
        return NumberUtil.toLong((String)this.value);
    }

    @Override
    public Float asFloat() {
        return Float.valueOf(this.value);
    }

    @Override
    public Double asDouble() {
        return Double.valueOf(this.value);
    }

    @Override
    public Date asDate() {
        return DateFormatUtil.stringToDate((String)this.asString());
    }

    @Override
    public Timestamp asTimestamp() {
        try {
            if (NumberUtil.isCreatable((String)this.value)) {
                return new Timestamp(this.asLong());
            }
            return DateFormatUtil.stringToTimestamp((String)this.value);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object asTime() {
        return this.asString();
    }

    @Override
    public byte[] asByteArray() {
        return StringUtil.hexStringToByteArray((String)this.value.substring(2));
    }
}

