/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public abstract class OnEndpointElementCondition
extends SpringBootCondition {
    private final String prefix;
    private final Class<? extends Annotation> annotationType;

    protected OnEndpointElementCondition(String prefix, Class<? extends Annotation> annotationType) {
        this.prefix = prefix;
        this.annotationType = annotationType;
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(this.annotationType.getName()));
        String endpointName = annotationAttributes.getString("value");
        ConditionOutcome outcome = this.getEndpointOutcome(context, endpointName);
        if (outcome != null) {
            return outcome;
        }
        return this.getDefaultEndpointsOutcome(context);
    }

    protected ConditionOutcome getEndpointOutcome(ConditionContext context, String endpointName) {
        String enabledProperty;
        Environment environment = context.getEnvironment();
        if (environment.containsProperty(enabledProperty = this.prefix + endpointName + ".enabled")) {
            boolean match = (Boolean)environment.getProperty(enabledProperty, Boolean.class, (Object)true);
            return new ConditionOutcome(match, ConditionMessage.forCondition(this.annotationType, (Object[])new Object[0]).because(this.prefix + endpointName + ".enabled is " + match));
        }
        return null;
    }

    protected ConditionOutcome getDefaultEndpointsOutcome(ConditionContext context) {
        boolean match = Boolean.parseBoolean(context.getEnvironment().getProperty(this.prefix + "defaults.enabled", "true"));
        return new ConditionOutcome(match, ConditionMessage.forCondition(this.annotationType, (Object[])new Object[0]).because(this.prefix + "defaults.enabled is considered " + match));
    }
}

