/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.mappings;

import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.web.mappings.MappingDescriptionProvider;
import org.springframework.boot.actuate.web.mappings.MappingsEndpoint;
import org.springframework.boot.actuate.web.mappings.reactive.DispatcherHandlersMappingDescriptionProvider;
import org.springframework.boot.actuate.web.mappings.servlet.DispatcherServletsMappingDescriptionProvider;
import org.springframework.boot.actuate.web.mappings.servlet.FiltersMappingDescriptionProvider;
import org.springframework.boot.actuate.web.mappings.servlet.ServletsMappingDescriptionProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration(proxyBeanMethods=false)
@ConditionalOnAvailableEndpoint(endpoint=MappingsEndpoint.class)
public class MappingsEndpointAutoConfiguration {
    @Bean
    public MappingsEndpoint mappingsEndpoint(ApplicationContext applicationContext, ObjectProvider<MappingDescriptionProvider> descriptionProviders) {
        return new MappingsEndpoint((Collection)descriptionProviders.orderedStream().collect(Collectors.toList()), applicationContext);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @ConditionalOnClass(value={DispatcherHandler.class})
    @ConditionalOnBean(value={DispatcherHandler.class})
    static class ReactiveWebConfiguration {
        ReactiveWebConfiguration() {
        }

        @Bean
        DispatcherHandlersMappingDescriptionProvider dispatcherHandlerMappingDescriptionProvider() {
            return new DispatcherHandlersMappingDescriptionProvider();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    static class ServletWebConfiguration {
        ServletWebConfiguration() {
        }

        @Bean
        ServletsMappingDescriptionProvider servletMappingDescriptionProvider() {
            return new ServletsMappingDescriptionProvider();
        }

        @Bean
        FiltersMappingDescriptionProvider filterMappingDescriptionProvider() {
            return new FiltersMappingDescriptionProvider();
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={DispatcherServlet.class})
        @ConditionalOnBean(value={DispatcherServlet.class})
        static class SpringMvcConfiguration {
            SpringMvcConfiguration() {
            }

            @Bean
            DispatcherServletsMappingDescriptionProvider dispatcherServletMappingDescriptionProvider() {
                return new DispatcherServletsMappingDescriptionProvider();
            }
        }
    }
}

